/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.filtering.kalman;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.filtering.LocalizedFilterFormats;
import org.hipparchus.filtering.kalman.KalmanEstimate;
import org.hipparchus.filtering.kalman.KalmanObserver;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;

public class KalmanSmoother
implements KalmanObserver {
    private final MatrixDecomposer decomposer;
    private final List<SmootherData> smootherData;

    public KalmanSmoother(MatrixDecomposer decomposer) {
        this.decomposer = decomposer;
        this.smootherData = new ArrayList<SmootherData>();
    }

    @Override
    public void init(KalmanEstimate estimate) {
        this.smootherData.add(new SmootherData(estimate.getCorrected().getTime(), null, null, estimate.getCorrected().getState(), estimate.getCorrected().getCovariance(), null));
    }

    @Override
    public void updatePerformed(KalmanEstimate estimate) {
        RealMatrix smootherGain = this.decomposer.decompose(estimate.getPredicted().getCovariance()).solve(estimate.getStateCrossCovariance().transpose()).transpose();
        this.smootherData.add(new SmootherData(estimate.getCorrected().getTime(), estimate.getPredicted().getState(), estimate.getPredicted().getCovariance(), estimate.getCorrected().getState(), estimate.getCorrected().getCovariance(), smootherGain));
    }

    public List<ProcessEstimate> backwardsSmooth() {
        if (this.smootherData.size() < 2) {
            throw new MathIllegalStateException((Localizable)LocalizedFilterFormats.PROCESS_AT_LEAST_ONE_MEASUREMENT, new Object[0]);
        }
        LinkedList<ProcessEstimate> smootherResults = new LinkedList<ProcessEstimate>();
        SmootherData lastUpdate = this.smootherData.get(this.smootherData.size() - 1);
        ProcessEstimate smoothedState = new ProcessEstimate(lastUpdate.getTime(), lastUpdate.getCorrectedState(), lastUpdate.getCorrectedCovariance());
        smootherResults.addFirst(smoothedState);
        for (int i = this.smootherData.size() - 2; i >= 0; --i) {
            RealMatrix smootherGain = this.smootherData.get(i + 1).getSmootherGain();
            RealVector smoothedMean = this.smootherData.get(i).getCorrectedState().add(smootherGain.operate(smoothedState.getState().subtract(this.smootherData.get(i + 1).getPredictedState())));
            RealMatrix smoothedCovariance = this.smootherData.get(i).getCorrectedCovariance().add(smootherGain.multiply(smoothedState.getCovariance().subtract(this.smootherData.get(i + 1).getPredictedCovariance())).multiplyTransposed(smootherGain));
            smoothedState = new ProcessEstimate(this.smootherData.get(i).getTime(), smoothedMean, smoothedCovariance);
            smootherResults.addFirst(smoothedState);
        }
        return smootherResults;
    }

    private static class SmootherData {
        private final double time;
        private final RealVector predictedState;
        private final RealMatrix predictedCovariance;
        private final RealVector correctedState;
        private final RealMatrix correctedCovariance;
        private final RealMatrix smootherGain;

        SmootherData(double time, RealVector predictedState, RealMatrix predictedCovariance, RealVector correctedState, RealMatrix correctedCovariance, RealMatrix smootherGain) {
            this.time = time;
            this.predictedState = predictedState;
            this.predictedCovariance = predictedCovariance;
            this.correctedState = correctedState;
            this.correctedCovariance = correctedCovariance;
            this.smootherGain = smootherGain;
        }

        public double getTime() {
            return this.time;
        }

        public RealVector getPredictedState() {
            return this.predictedState;
        }

        public RealMatrix getPredictedCovariance() {
            return this.predictedCovariance;
        }

        public RealVector getCorrectedState() {
            return this.correctedState;
        }

        public RealMatrix getCorrectedCovariance() {
            return this.correctedCovariance;
        }

        public RealMatrix getSmootherGain() {
            return this.smootherGain;
        }
    }
}

