/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.Pair;

public interface UnscentedTransformProvider {
    public RealVector[] unscentedTransform(RealVector var1, RealMatrix var2);

    default public RealVector getUnscentedMeanState(RealVector[] sigmaPoints) {
        int sigmaPointDimension = sigmaPoints[0].getDimension();
        RealVector weightedMean = new ArrayRealVector(sigmaPointDimension);
        RealVector wm = this.getWm();
        for (int i = 0; i < sigmaPoints.length; ++i) {
            weightedMean = ((RealVector)weightedMean).add(sigmaPoints[i].mapMultiply(wm.getEntry(i)));
        }
        return weightedMean;
    }

    default public RealMatrix getUnscentedCovariance(RealVector[] sigmaPoints, RealVector meanState) {
        int stateDimension = meanState.getDimension();
        RealMatrix covarianceMatrix = MatrixUtils.createRealMatrix(stateDimension, stateDimension);
        RealVector wc = this.getWc();
        for (int i = 0; i < sigmaPoints.length; ++i) {
            RealMatrix diff = MatrixUtils.createColumnRealMatrix(sigmaPoints[i].subtract(meanState).toArray());
            covarianceMatrix = covarianceMatrix.add(diff.multiplyTransposed(diff).scalarMultiply(wc.getEntry(i)));
        }
        return covarianceMatrix;
    }

    default public Pair<RealVector, RealMatrix> inverseUnscentedTransform(RealVector[] sigmaPoints) {
        RealVector meanState = this.getUnscentedMeanState(sigmaPoints);
        return new Pair<RealVector, RealMatrix>(meanState, this.getUnscentedCovariance(sigmaPoints, meanState));
    }

    public RealVector getWc();

    public RealVector getWm();
}

