/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.hipparchus.util.AbstractOpenIntHashMap;

public class OpenIntToDoubleHashMap
extends AbstractOpenIntHashMap
implements Serializable {
    private static final long serialVersionUID = 20240326L;
    private double[] values = new double[this.getCapacity()];
    private final double missingEntries;

    public OpenIntToDoubleHashMap() {
        this(16, Double.NaN);
    }

    public OpenIntToDoubleHashMap(double missingEntries) {
        this(16, missingEntries);
    }

    public OpenIntToDoubleHashMap(int expectedSize) {
        this(expectedSize, Double.NaN);
    }

    public OpenIntToDoubleHashMap(int expectedSize, double missingEntries) {
        super(expectedSize);
        this.missingEntries = missingEntries;
    }

    public OpenIntToDoubleHashMap(OpenIntToDoubleHashMap source) {
        super(source);
        System.arraycopy(source.values, 0, this.values, 0, this.getCapacity());
        this.missingEntries = source.missingEntries;
    }

    public double get(int key) {
        int index = this.locate(key);
        return index < 0 ? this.missingEntries : this.values[index];
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIntToDoubleHashMap that = (OpenIntToDoubleHashMap)o;
        return this.equalKeys(that) && this.equalStates(that) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.keysStatesHashCode() + Arrays.hashCode(this.values);
    }

    public double remove(int key) {
        int index = this.locate(key);
        if (index < 0) {
            return this.missingEntries;
        }
        double previous = this.values[index];
        this.doRemove(index);
        this.values[index] = this.missingEntries;
        return previous;
    }

    public double put(int key, double value) {
        AbstractOpenIntHashMap.InsertionHolder ih = this.put(key);
        double previous = ih.isExisting() ? this.values[ih.getIndex()] : this.missingEntries;
        this.values[ih.getIndex()] = value;
        return previous;
    }

    @Override
    protected int growTable(int oldIndex) {
        double[] newValues = new double[2 * this.values.length];
        int newIndex = this.doGrowTable(oldIndex, (src, dest) -> {
            newValues[dest] = this.values[src];
        });
        this.values = newValues;
        return newIndex;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.resetCount();
    }

    private Object writeReplace() {
        return new DataTransferObject(this.missingEntries, this.getSize(), this.iterator());
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20240326L;
        private final double missingEntries;
        private final int[] keys;
        private final double[] values;

        DataTransferObject(double missingEntries, int size, Iterator iterator) {
            this.missingEntries = missingEntries;
            this.keys = new int[size];
            this.values = new double[size];
            for (int i = 0; i < size; ++i) {
                iterator.advance();
                this.keys[i] = iterator.key();
                this.values[i] = iterator.value();
            }
        }

        private Object readResolve() {
            OpenIntToDoubleHashMap map = new OpenIntToDoubleHashMap(this.missingEntries);
            for (int i = 0; i < this.keys.length; ++i) {
                map.put(this.keys[i], this.values[i]);
            }
            return map;
        }
    }

    public class Iterator
    extends AbstractOpenIntHashMap.BaseIterator {
        public Iterator() {
            super(OpenIntToDoubleHashMap.this);
        }

        public double value() throws ConcurrentModificationException, NoSuchElementException {
            return OpenIntToDoubleHashMap.this.values[this.getCurrent()];
        }
    }
}

