/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.AbstractUnscentedTransform;

public class MerweUnscentedTransform
extends AbstractUnscentedTransform {
    public static final double DEFAULT_ALPHA = 0.5;
    public static final double DEFAULT_BETA = 2.0;
    public static final double DEFAULT_KAPPA = 0.0;
    private final RealVector wc;
    private final RealVector wm;
    private final double factor;

    public MerweUnscentedTransform(int stateDim) {
        this(stateDim, 0.5, 2.0, 0.0);
    }

    public MerweUnscentedTransform(int stateDim, double alpha, double beta, double kappa) {
        super(stateDim);
        double lambda = alpha * alpha * ((double)stateDim + kappa) - (double)stateDim;
        this.factor = (double)stateDim + lambda;
        this.wm = new ArrayRealVector(2 * stateDim + 1);
        this.wc = new ArrayRealVector(2 * stateDim + 1);
        this.wm.setEntry(0, lambda / this.factor);
        this.wc.setEntry(0, lambda / this.factor + (1.0 - alpha * alpha + beta));
        double w = 1.0 / (2.0 * this.factor);
        for (int i = 1; i <= 2 * stateDim; ++i) {
            this.wm.setEntry(i, w);
            this.wc.setEntry(i, w);
        }
    }

    @Override
    public RealVector getWc() {
        return this.wc;
    }

    @Override
    public RealVector getWm() {
        return this.wm;
    }

    @Override
    protected double getMultiplicationFactor() {
        return this.factor;
    }
}

