/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.AbstractUnscentedTransform;

public class JulierUnscentedTransform
extends AbstractUnscentedTransform {
    public static final double DEFAULT_KAPPA = 0.0;
    private final RealVector wc;
    private final RealVector wm;
    private final double factor;

    public JulierUnscentedTransform(int stateDim) {
        this(stateDim, 0.0);
    }

    public JulierUnscentedTransform(int stateDim, double kappa) {
        super(stateDim);
        this.factor = (double)stateDim + kappa;
        this.wm = new ArrayRealVector(2 * stateDim + 1);
        this.wm.setEntry(0, kappa / this.factor);
        for (int i = 1; i <= 2 * stateDim; ++i) {
            this.wm.setEntry(i, 1.0 / (2.0 * this.factor));
        }
        this.wc = this.wm;
    }

    @Override
    public RealVector getWc() {
        return this.wc;
    }

    @Override
    public RealVector getWm() {
        return this.wm;
    }

    @Override
    protected double getMultiplicationFactor() {
        return this.factor;
    }
}

