/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.special.elliptic.jacobi.CopolarN;
import org.hipparchus.special.elliptic.jacobi.JacobiElliptic;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinhCosh;

class NearOneParameter
extends JacobiElliptic {
    private final double m1;

    NearOneParameter(double m) {
        super(m);
        this.m1 = 1.0 - m;
    }

    @Override
    public CopolarN valuesN(double u) {
        SinhCosh sch = FastMath.sinhCosh(u);
        double sech = 1.0 / sch.cosh();
        double t = sch.sinh() * sech;
        double factor = 0.25 * this.m1 * (sch.sinh() * sch.cosh() - u) * sech;
        return new CopolarN(t + factor * sech, sech - factor * t, sech + factor * t);
    }
}

