/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinhCosh;

class FieldNearOneParameter<T extends CalculusFieldElement<T>>
extends FieldJacobiElliptic<T> {
    private final T m1Fourth;

    FieldNearOneParameter(T m) {
        super(m);
        this.m1Fourth = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m.getField().getOne()).subtract(m)).multiply(0.25);
    }

    @Override
    public FieldCopolarN<T> valuesN(T u) {
        FieldSinhCosh<T> sch = FastMath.sinhCosh(u);
        CalculusFieldElement sech = (CalculusFieldElement)((CalculusFieldElement)sch.cosh()).reciprocal();
        CalculusFieldElement t = ((CalculusFieldElement)sch.sinh()).multiply(sech);
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sch.sinh()).multiply((CalculusFieldElement)sch.cosh()).subtract(u)).multiply(sech).multiply(this.m1Fourth);
        return new FieldCopolarN<CalculusFieldElement>(t.add(factor.multiply(sech)), sech.subtract(factor.multiply(t)), sech.add(factor.multiply(t)));
    }
}

