/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.IterativeLinearSolver;
import org.hipparchus.linear.RealLinearOperator;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.IterationManager;
import org.hipparchus.util.MathUtils;

public abstract class PreconditionedIterativeLinearSolver
extends IterativeLinearSolver {
    protected PreconditionedIterativeLinearSolver(int maxIterations) {
        super(maxIterations);
    }

    public PreconditionedIterativeLinearSolver(IterationManager manager) throws NullArgumentException {
        super(manager);
    }

    public RealVector solve(RealLinearOperator a, RealLinearOperator m, RealVector b, RealVector x0) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        MathUtils.checkNotNull(x0);
        return this.solveInPlace(a, m, b, x0.copy());
    }

    @Override
    public RealVector solve(RealLinearOperator a, RealVector b) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        MathUtils.checkNotNull(a);
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        ((RealVector)x).set(0.0);
        return this.solveInPlace(a, null, b, x);
    }

    @Override
    public RealVector solve(RealLinearOperator a, RealVector b, RealVector x0) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        MathUtils.checkNotNull(x0);
        return this.solveInPlace(a, null, b, x0.copy());
    }

    protected static void checkParameters(RealLinearOperator a, RealLinearOperator m, RealVector b, RealVector x0) throws MathIllegalArgumentException, NullArgumentException {
        PreconditionedIterativeLinearSolver.checkParameters(a, b, x0);
        if (m != null) {
            if (m.getColumnDimension() != m.getRowDimension()) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_OPERATOR, m.getColumnDimension(), m.getRowDimension());
            }
            if (m.getRowDimension() != a.getRowDimension()) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, m.getRowDimension(), a.getRowDimension());
            }
        }
    }

    public RealVector solve(RealLinearOperator a, RealLinearOperator m, RealVector b) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        MathUtils.checkNotNull(a);
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        return this.solveInPlace(a, m, b, x);
    }

    public abstract RealVector solveInPlace(RealLinearOperator var1, RealLinearOperator var2, RealVector var3, RealVector var4) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException;

    @Override
    public RealVector solveInPlace(RealLinearOperator a, RealVector b, RealVector x0) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return this.solveInPlace(a, null, b, x0);
    }
}

