/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealLinearOperator;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.IterationManager;
import org.hipparchus.util.MathUtils;

public abstract class IterativeLinearSolver {
    private final IterationManager manager;

    protected IterativeLinearSolver(int maxIterations) {
        this.manager = new IterationManager(maxIterations);
    }

    protected IterativeLinearSolver(IterationManager manager) throws NullArgumentException {
        MathUtils.checkNotNull(manager);
        this.manager = manager;
    }

    protected static void checkParameters(RealLinearOperator a, RealVector b, RealVector x0) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(a);
        MathUtils.checkNotNull(b);
        MathUtils.checkNotNull(x0);
        if (a.getRowDimension() != a.getColumnDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_OPERATOR, a.getRowDimension(), a.getColumnDimension());
        }
        if (b.getDimension() != a.getRowDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getDimension(), a.getRowDimension());
        }
        if (x0.getDimension() != a.getColumnDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, x0.getDimension(), a.getColumnDimension());
        }
    }

    public IterationManager getIterationManager() {
        return this.manager;
    }

    public RealVector solve(RealLinearOperator a, RealVector b) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        MathUtils.checkNotNull(a);
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        ((RealVector)x).set(0.0);
        return this.solveInPlace(a, b, x);
    }

    public RealVector solve(RealLinearOperator a, RealVector b, RealVector x0) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        MathUtils.checkNotNull(x0);
        return this.solveInPlace(a, b, x0.copy());
    }

    public abstract RealVector solveInPlace(RealLinearOperator var1, RealVector var2, RealVector var3) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException;
}

