/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.fraction;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Pair;
import org.hipparchus.util.Precision;

class ConvergentsIterator {
    private ConvergentsIterator() {
    }

    static Pair<ConvergenceStep, Boolean> convergent(double value, int maxConvergents, Predicate<ConvergenceStep> convergenceTests) {
        ConvergenceStep step = ConvergenceStep.start(value);
        for (int i = 1; i < maxConvergents; ++i) {
            if (convergenceTests.test(step)) {
                return Pair.create(step, Boolean.TRUE);
            }
            step = step.next();
        }
        return Pair.create(step, convergenceTests.test(step));
    }

    static Stream<ConvergenceStep> convergents(final double value, int maxConvergents) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<ConvergenceStep>(){
            private ConvergenceStep next;
            {
                this.next = ConvergenceStep.start(value);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ConvergenceStep next() {
                ConvergenceStep ret = this.next;
                this.next = Precision.equals(ret.getFractionValue(), value, 1) ? null : this.next.next();
                return ret;
            }
        }, 1297), false).limit(maxConvergents);
    }

    static class ConvergenceStep {
        private final long p0;
        private final long q0;
        private final long p1;
        private final long q1;
        private final double r1;

        private ConvergenceStep(long p0, long q0, long p1, long q1, double r1) {
            this.p0 = p1;
            this.q0 = q1;
            long a1 = (long)FastMath.floor(r1);
            try {
                this.p1 = FastMath.addExact(Math.multiplyExact(a1, p1), p0);
                this.q1 = FastMath.addExact(Math.multiplyExact(a1, q1), q0);
                this.r1 = 1.0 / (r1 - (double)a1);
            }
            catch (ArithmeticException e) {
                throw new MathIllegalStateException(e, LocalizedCoreFormats.FRACTION_CONVERSION_OVERFLOW, r1, p1, q1);
            }
        }

        public static ConvergenceStep start(double value) {
            return new ConvergenceStep(0L, 1L, 1L, 0L, value);
        }

        public ConvergenceStep next() {
            return new ConvergenceStep(this.p0, this.q0, this.p1, this.q1, this.r1);
        }

        public long getNumerator() {
            return this.p1;
        }

        public long getDenominator() {
            return this.q1;
        }

        public double getFractionValue() {
            return (double)this.getNumerator() / (double)this.getDenominator();
        }

        public String toString() {
            return this.getNumerator() + "/" + this.getDenominator();
        }
    }
}

