/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.solvers;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BaseUnivariateSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.MathUtils;

public abstract class BaseAbstractUnivariateSolver<F extends UnivariateFunction>
implements BaseUnivariateSolver<F> {
    private static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-14;
    private static final double DEFAULT_FUNCTION_VALUE_ACCURACY = 1.0E-15;
    private final double functionValueAccuracy;
    private final double absoluteAccuracy;
    private final double relativeAccuracy;
    private Incrementor evaluations;
    private double searchMin;
    private double searchMax;
    private double searchStart;
    private F function;

    protected BaseAbstractUnivariateSolver(double absoluteAccuracy) {
        this(1.0E-14, absoluteAccuracy, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double relativeAccuracy, double absoluteAccuracy) {
        this(relativeAccuracy, absoluteAccuracy, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
        this.absoluteAccuracy = absoluteAccuracy;
        this.relativeAccuracy = relativeAccuracy;
        this.functionValueAccuracy = functionValueAccuracy;
        this.evaluations = new Incrementor();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public double getMin() {
        return this.searchMin;
    }

    public double getMax() {
        return this.searchMax;
    }

    public double getStartValue() {
        return this.searchStart;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double getFunctionValueAccuracy() {
        return this.functionValueAccuracy;
    }

    protected double computeObjectiveValue(double point) throws MathIllegalStateException {
        this.incrementEvaluationCount();
        return this.function.value(point);
    }

    protected void setup(int maxEval, F f, double min, double max, double startValue) throws NullArgumentException {
        MathUtils.checkNotNull(f);
        this.searchMin = min;
        this.searchMax = max;
        this.searchStart = startValue;
        this.function = f;
        this.evaluations = this.evaluations.withMaximalCount(maxEval);
    }

    @Override
    public double solve(int maxEval, F f, double min, double max, double startValue) throws MathIllegalArgumentException, MathIllegalStateException {
        this.setup(maxEval, f, min, max, startValue);
        return this.doSolve();
    }

    @Override
    public double solve(int maxEval, F f, double min, double max) {
        return this.solve(maxEval, f, min, max, min + 0.5 * (max - min));
    }

    @Override
    public double solve(int maxEval, F f, double startValue) throws MathIllegalArgumentException, MathIllegalStateException {
        return this.solve(maxEval, f, Double.NaN, Double.NaN, startValue);
    }

    protected abstract double doSolve() throws MathIllegalArgumentException, MathIllegalStateException;

    protected boolean isBracketing(double lower, double upper) {
        return UnivariateSolverUtils.isBracketing(this.function, lower, upper);
    }

    protected boolean isSequence(double start, double mid, double end) {
        return UnivariateSolverUtils.isSequence(start, mid, end);
    }

    protected void verifyInterval(double lower, double upper) throws MathIllegalArgumentException {
        UnivariateSolverUtils.verifyInterval(lower, upper);
    }

    protected void verifySequence(double lower, double initial, double upper) throws MathIllegalArgumentException {
        UnivariateSolverUtils.verifySequence(lower, initial, upper);
    }

    protected void verifyBracketing(double lower, double upper) throws MathIllegalArgumentException, NullArgumentException {
        UnivariateSolverUtils.verifyBracketing(this.function, lower, upper);
    }

    protected void incrementEvaluationCount() throws MathIllegalStateException {
        this.evaluations.increment();
    }
}

