/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import java.lang.reflect.Array;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.interpolation.FieldUnivariateInterpolator;
import org.hipparchus.analysis.interpolation.UnivariateInterpolator;
import org.hipparchus.analysis.polynomials.FieldPolynomialFunction;
import org.hipparchus.analysis.polynomials.FieldPolynomialSplineFunction;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class LinearInterpolator
implements UnivariateInterpolator,
FieldUnivariateInterpolator {
    @Override
    public PolynomialSplineFunction interpolate(double[] x, double[] y) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(x);
        MathUtils.checkNotNull(y);
        MathArrays.checkEqualLength(x, y);
        if (x.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, x.length, 2, true);
        }
        int n = x.length - 1;
        MathArrays.checkOrder(x);
        double[] m = new double[n];
        for (int i = 0; i < n; ++i) {
            m[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[2];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = m[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x, polynomials);
    }

    public <T extends CalculusFieldElement<T>> FieldPolynomialSplineFunction<T> interpolate(T[] x, T[] y) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(x);
        MathUtils.checkNotNull(y);
        MathArrays.checkEqualLength(x, y);
        if (x.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, x.length, 2, true);
        }
        int n = x.length - 1;
        MathArrays.checkOrder(x);
        CalculusFieldElement[] m = (CalculusFieldElement[])MathArrays.buildArray(x[0].getField(), (int)n);
        for (int i = 0; i < n; ++i) {
            m[i] = ((CalculusFieldElement)y[i + 1].subtract(y[i])).divide((CalculusFieldElement)x[i + 1].subtract(x[i]));
        }
        FieldPolynomialFunction[] polynomials = (FieldPolynomialFunction[])Array.newInstance(FieldPolynomialFunction.class, n);
        CalculusFieldElement[] coefficients = (CalculusFieldElement[])MathArrays.buildArray(x[0].getField(), (int)2);
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = m[i];
            polynomials[i] = new FieldPolynomialFunction(coefficients);
        }
        return new FieldPolynomialSplineFunction(x, polynomials);
    }
}

