/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.gauss.FieldAbstractRuleFactory;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Pair;

public class FieldLegendreRuleFactory<T extends CalculusFieldElement<T>>
extends FieldAbstractRuleFactory<T> {
    public FieldLegendreRuleFactory(Field<T> field) {
        super(field);
    }

    @Override
    public Pair<T[], T[]> computeRule(int numberOfPoints) throws MathIllegalArgumentException {
        Field field = this.getField();
        if (numberOfPoints == 1) {
            CalculusFieldElement[] points = (CalculusFieldElement[])MathArrays.buildArray(field, (int)numberOfPoints);
            CalculusFieldElement[] weights = (CalculusFieldElement[])MathArrays.buildArray(field, (int)numberOfPoints);
            points[0] = (CalculusFieldElement)field.getZero();
            weights[0] = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(2.0);
            return new Pair<CalculusFieldElement[], CalculusFieldElement[]>(points, weights);
        }
        Legendre p = new Legendre(numberOfPoints);
        CalculusFieldElement[] points = this.findRoots(numberOfPoints, p::ratio);
        this.enforceSymmetry(points);
        CalculusFieldElement[] weights = (CalculusFieldElement[])MathArrays.buildArray(field, (int)numberOfPoints);
        for (int i = 0; i <= numberOfPoints / 2; ++i) {
            CalculusFieldElement c = points[i];
            CalculusFieldElement[] pKpKm1 = p.pNpNm1(c);
            CalculusFieldElement d = (CalculusFieldElement)pKpKm1[1].subtract(c.multiply(pKpKm1[0])).multiply(numberOfPoints);
            weights[i] = ((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c.square()).subtract(1.0)).multiply(-2)).divide(d.multiply(d));
            int idx = numberOfPoints - i - 1;
            weights[idx] = weights[i];
        }
        return new Pair<CalculusFieldElement[], CalculusFieldElement[]>(points, weights);
    }

    private static class Legendre<T extends CalculusFieldElement<T>> {
        private int degree;

        Legendre(int degree) {
            this.degree = degree;
        }

        public T ratio(T x) {
            CalculusFieldElement pm = (CalculusFieldElement)x.getField().getOne();
            CalculusFieldElement p = x;
            CalculusFieldElement d = (CalculusFieldElement)x.getField().getOne();
            for (int n = 1; n < this.degree; ++n) {
                CalculusFieldElement pp = (CalculusFieldElement)p.multiply((CalculusFieldElement)((CalculusFieldElement)x.multiply(2 * n + 1))).subtract((CalculusFieldElement)pm.multiply(n)).divide((double)(n + 1));
                d = ((CalculusFieldElement)p.multiply(n + 1)).add((CalculusFieldElement)d.multiply(x));
                pm = p;
                p = pp;
            }
            return (T)p.divide((CalculusFieldElement)d);
        }

        private T[] pNpNm1(T x) {
            CalculusFieldElement[] p = (CalculusFieldElement[])MathArrays.buildArray(x.getField(), (int)2);
            p[0] = x;
            p[1] = (CalculusFieldElement)x.getField().getOne();
            for (int n = 1; n < this.degree; ++n) {
                CalculusFieldElement pp = (CalculusFieldElement)p[0].multiply((CalculusFieldElement)x.multiply(2 * n + 1)).subtract((CalculusFieldElement)p[1].multiply(n)).divide((double)(n + 1));
                p[1] = p[0];
                p[0] = pp;
            }
            return p;
        }
    }
}

