/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.gauss.FieldGaussIntegrator;
import org.hipparchus.analysis.integration.gauss.FieldHermiteRuleFactory;
import org.hipparchus.analysis.integration.gauss.FieldLaguerreRuleFactory;
import org.hipparchus.analysis.integration.gauss.FieldLegendreRuleFactory;
import org.hipparchus.analysis.integration.gauss.FieldRuleFactory;
import org.hipparchus.analysis.integration.gauss.SymmetricFieldGaussIntegrator;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.Pair;

public class FieldGaussIntegratorFactory<T extends CalculusFieldElement<T>> {
    private final FieldRuleFactory<T> legendre;
    private final FieldRuleFactory<T> hermite;
    private final FieldRuleFactory<T> laguerre;

    public FieldGaussIntegratorFactory(Field<T> field) {
        this.legendre = new FieldLegendreRuleFactory<T>(field);
        this.hermite = new FieldHermiteRuleFactory<T>(field);
        this.laguerre = new FieldLaguerreRuleFactory<T>(field);
    }

    public FieldGaussIntegrator<T> laguerre(int numberOfPoints) {
        return new FieldGaussIntegrator(this.laguerre.getRule(numberOfPoints));
    }

    public FieldGaussIntegrator<T> legendre(int numberOfPoints) {
        return new FieldGaussIntegrator(this.legendre.getRule(numberOfPoints));
    }

    public FieldGaussIntegrator<T> legendre(int numberOfPoints, T lowerBound, T upperBound) throws MathIllegalArgumentException {
        return new FieldGaussIntegrator(this.transform(this.legendre.getRule(numberOfPoints), lowerBound, upperBound));
    }

    public SymmetricFieldGaussIntegrator<T> hermite(int numberOfPoints) {
        return new SymmetricFieldGaussIntegrator(this.hermite.getRule(numberOfPoints));
    }

    private Pair<T[], T[]> transform(Pair<T[], T[]> rule, T a, T b) {
        CalculusFieldElement[] points = (CalculusFieldElement[])rule.getFirst();
        CalculusFieldElement[] weights = (CalculusFieldElement[])rule.getSecond();
        CalculusFieldElement scale = (CalculusFieldElement)((CalculusFieldElement)b.subtract(a)).multiply(0.5);
        CalculusFieldElement shift = a.add((CalculusFieldElement)scale);
        for (int i = 0; i < points.length; ++i) {
            points[i] = points[i].multiply(scale).add(shift);
            weights[i] = weights[i].multiply(scale);
        }
        return new Pair<CalculusFieldElement[], CalculusFieldElement[]>(points, weights);
    }
}

