/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.UnivariateDerivative;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2Field;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.hipparchus.util.SinhCosh;

public class UnivariateDerivative2
extends UnivariateDerivative<UnivariateDerivative2> {
    public static final UnivariateDerivative2 PI = new UnivariateDerivative2(Math.PI, 0.0, 0.0);
    private static final long serialVersionUID = 20200520L;
    private final double f0;
    private final double f1;
    private final double f2;

    public UnivariateDerivative2(double f0, double f1, double f2) {
        this.f0 = f0;
        this.f1 = f1;
        this.f2 = f2;
    }

    public UnivariateDerivative2(DerivativeStructure ds) throws MathIllegalArgumentException {
        MathUtils.checkDimension(ds.getFreeParameters(), 1);
        MathUtils.checkDimension(ds.getOrder(), 2);
        this.f0 = ds.getValue();
        this.f1 = ds.getPartialDerivative(1);
        this.f2 = ds.getPartialDerivative(2);
    }

    @Override
    public UnivariateDerivative2 newInstance(double value) {
        return new UnivariateDerivative2(value, 0.0, 0.0);
    }

    @Override
    public UnivariateDerivative2 withValue(double value) {
        return new UnivariateDerivative2(value, this.f1, this.f2);
    }

    @Override
    public UnivariateDerivative2 getAddendum() {
        return new UnivariateDerivative2(0.0, this.f1, this.f2);
    }

    @Override
    public double getValue() {
        return this.f0;
    }

    @Override
    public double getDerivative(int n) {
        switch (n) {
            case 0: {
                return this.f0;
            }
            case 1: {
                return this.f1;
            }
            case 2: {
                return this.f2;
            }
        }
        throw new MathIllegalArgumentException(LocalizedCoreFormats.DERIVATION_ORDER_NOT_ALLOWED, n);
    }

    @Override
    public int getOrder() {
        return 2;
    }

    public double getFirstDerivative() {
        return this.f1;
    }

    public double getSecondDerivative() {
        return this.f2;
    }

    @Override
    public DerivativeStructure toDerivativeStructure() {
        return this.getField().getConversionFactory().build(this.f0, this.f1, this.f2);
    }

    @Override
    public UnivariateDerivative2 add(UnivariateDerivative2 a) {
        return new UnivariateDerivative2(this.f0 + a.f0, this.f1 + a.f1, this.f2 + a.f2);
    }

    @Override
    public UnivariateDerivative2 subtract(UnivariateDerivative2 a) {
        return new UnivariateDerivative2(this.f0 - a.f0, this.f1 - a.f1, this.f2 - a.f2);
    }

    @Override
    public UnivariateDerivative2 multiply(int n) {
        return new UnivariateDerivative2(this.f0 * (double)n, this.f1 * (double)n, this.f2 * (double)n);
    }

    @Override
    public UnivariateDerivative2 multiply(double a) {
        return new UnivariateDerivative2(this.f0 * a, this.f1 * a, this.f2 * a);
    }

    @Override
    public UnivariateDerivative2 multiply(UnivariateDerivative2 a) {
        return new UnivariateDerivative2(this.f0 * a.f0, MathArrays.linearCombination(this.f1, a.f0, this.f0, a.f1), MathArrays.linearCombination(this.f2, a.f0, 2.0 * this.f1, a.f1, this.f0, a.f2));
    }

    @Override
    public UnivariateDerivative2 square() {
        return new UnivariateDerivative2(this.f0 * this.f0, 2.0 * this.f0 * this.f1, 2.0 * (this.f0 * this.f2 + this.f1 * this.f1));
    }

    @Override
    public UnivariateDerivative2 divide(double a) {
        double inv1 = 1.0 / a;
        return new UnivariateDerivative2(this.f0 * inv1, this.f1 * inv1, this.f2 * inv1);
    }

    @Override
    public UnivariateDerivative2 divide(UnivariateDerivative2 a) {
        double inv1 = 1.0 / a.f0;
        double inv2 = inv1 * inv1;
        double inv3 = inv1 * inv2;
        return new UnivariateDerivative2(this.f0 * inv1, MathArrays.linearCombination(this.f1, a.f0, -this.f0, a.f1) * inv2, MathArrays.linearCombination(this.f2, a.f0 * a.f0, -2.0 * this.f1, a.f0 * a.f1, 2.0 * this.f0, a.f1 * a.f1, -this.f0, a.f0 * a.f2) * inv3);
    }

    @Override
    public UnivariateDerivative2 remainder(UnivariateDerivative2 a) {
        double rem = FastMath.IEEEremainder(this.f0, a.f0);
        double k = FastMath.rint((this.f0 - rem) / a.f0);
        return new UnivariateDerivative2(rem, this.f1 - k * a.f1, this.f2 - k * a.f2);
    }

    @Override
    public UnivariateDerivative2 negate() {
        return new UnivariateDerivative2(-this.f0, -this.f1, -this.f2);
    }

    @Override
    public UnivariateDerivative2 abs() {
        if (Double.doubleToLongBits(this.f0) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public UnivariateDerivative2 copySign(UnivariateDerivative2 sign) {
        long m = Double.doubleToLongBits(this.f0);
        long s = Double.doubleToLongBits(sign.f0);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public UnivariateDerivative2 copySign(double sign) {
        long m = Double.doubleToLongBits(this.f0);
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public UnivariateDerivative2 scalb(int n) {
        return new UnivariateDerivative2(FastMath.scalb(this.f0, n), FastMath.scalb(this.f1, n), FastMath.scalb(this.f2, n));
    }

    @Override
    public UnivariateDerivative2 hypot(UnivariateDerivative2 y) {
        int expY;
        if (Double.isInfinite(this.f0) || Double.isInfinite(y.f0)) {
            return new UnivariateDerivative2(Double.POSITIVE_INFINITY, 0.0, 0.0);
        }
        if (Double.isNaN(this.f0) || Double.isNaN(y.f0)) {
            return new UnivariateDerivative2(Double.NaN, 0.0, 0.0);
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        UnivariateDerivative2 scaledX = this.scalb(-middleExp);
        UnivariateDerivative2 scaledY = y.scalb(-middleExp);
        UnivariateDerivative2 scaledH = scaledX.multiply(scaledX).add(scaledY.multiply(scaledY)).sqrt();
        return scaledH.scalb(middleExp);
    }

    @Override
    public UnivariateDerivative2 reciprocal() {
        double inv1 = 1.0 / this.f0;
        double inv2 = inv1 * inv1;
        double inv3 = inv1 * inv2;
        return new UnivariateDerivative2(inv1, -this.f1 * inv2, MathArrays.linearCombination(2.0 * this.f1, this.f1, -this.f0, this.f2) * inv3);
    }

    @Override
    public UnivariateDerivative2 compose(double ... f) {
        MathUtils.checkDimension(f.length, this.getOrder() + 1);
        return new UnivariateDerivative2(f[0], f[1] * this.f1, MathArrays.linearCombination(f[1], this.f2, f[2], this.f1 * this.f1));
    }

    @Override
    public UnivariateDerivative2 sqrt() {
        double s0 = FastMath.sqrt(this.f0);
        double s0twice = 2.0 * s0;
        double s1 = this.f1 / s0twice;
        double s2 = (this.f2 - 2.0 * s1 * s1) / s0twice;
        return new UnivariateDerivative2(s0, s1, s2);
    }

    @Override
    public UnivariateDerivative2 cbrt() {
        double c = FastMath.cbrt(this.f0);
        double c2 = c * c;
        return this.compose(c, 1.0 / (3.0 * c2), -1.0 / (4.5 * c2 * this.f0));
    }

    @Override
    public UnivariateDerivative2 rootN(int n) {
        if (n == 2) {
            return this.sqrt();
        }
        if (n == 3) {
            return this.cbrt();
        }
        double r = FastMath.pow(this.f0, 1.0 / (double)n);
        double z = (double)n * FastMath.pow(r, n - 1);
        return this.compose(r, 1.0 / z, (double)(1 - n) / (z * z * r));
    }

    public UnivariateDerivative2Field getField() {
        return UnivariateDerivative2Field.getInstance();
    }

    public static UnivariateDerivative2 pow(double a, UnivariateDerivative2 x) {
        if (a == 0.0) {
            return x.getField().getZero();
        }
        double aX = FastMath.pow(a, x.f0);
        double lnA = FastMath.log(a);
        double aXlnA = aX * lnA;
        return new UnivariateDerivative2(aX, aXlnA * x.f1, aXlnA * (x.f1 * x.f1 * lnA + x.f2));
    }

    @Override
    public UnivariateDerivative2 pow(double p) {
        if (p == 0.0) {
            return this.getField().getOne();
        }
        double f0Pm2 = FastMath.pow(this.f0, p - 2.0);
        double f0Pm1 = f0Pm2 * this.f0;
        double f0P = f0Pm1 * this.f0;
        return this.compose(f0P, p * f0Pm1, p * (p - 1.0) * f0Pm2);
    }

    @Override
    public UnivariateDerivative2 pow(int n) {
        if (n == 0) {
            return this.getField().getOne();
        }
        double f0Nm2 = FastMath.pow(this.f0, n - 2);
        double f0Nm1 = f0Nm2 * this.f0;
        double f0N = f0Nm1 * this.f0;
        return this.compose(f0N, (double)n * f0Nm1, (double)(n * (n - 1)) * f0Nm2);
    }

    @Override
    public UnivariateDerivative2 exp() {
        double exp = FastMath.exp(this.f0);
        return this.compose(exp, exp, exp);
    }

    @Override
    public UnivariateDerivative2 expm1() {
        double exp = FastMath.exp(this.f0);
        double expM1 = FastMath.expm1(this.f0);
        return this.compose(expM1, exp, exp);
    }

    @Override
    public UnivariateDerivative2 log() {
        double inv = 1.0 / this.f0;
        return this.compose(FastMath.log(this.f0), inv, -inv * inv);
    }

    @Override
    public UnivariateDerivative2 log1p() {
        double inv = 1.0 / (1.0 + this.f0);
        return this.compose(FastMath.log1p(this.f0), inv, -inv * inv);
    }

    @Override
    public UnivariateDerivative2 log10() {
        double invF0 = 1.0 / this.f0;
        double inv = invF0 / FastMath.log(10.0);
        return this.compose(FastMath.log10(this.f0), inv, -inv * invF0);
    }

    @Override
    public UnivariateDerivative2 cos() {
        SinCos sinCos = FastMath.sinCos(this.f0);
        return this.compose(sinCos.cos(), -sinCos.sin(), -sinCos.cos());
    }

    @Override
    public UnivariateDerivative2 sin() {
        SinCos sinCos = FastMath.sinCos(this.f0);
        return this.compose(sinCos.sin(), sinCos.cos(), -sinCos.sin());
    }

    @Override
    public FieldSinCos<UnivariateDerivative2> sinCos() {
        SinCos sinCos = FastMath.sinCos(this.f0);
        return new FieldSinCos<UnivariateDerivative2>(this.compose(sinCos.sin(), sinCos.cos(), -sinCos.sin()), this.compose(sinCos.cos(), -sinCos.sin(), -sinCos.cos()));
    }

    @Override
    public UnivariateDerivative2 tan() {
        double tan = FastMath.tan(this.f0);
        double sec2 = 1.0 + tan * tan;
        return this.compose(tan, sec2, 2.0 * sec2 * tan);
    }

    @Override
    public UnivariateDerivative2 acos() {
        double inv = 1.0 / (1.0 - this.f0 * this.f0);
        double mS = -FastMath.sqrt(inv);
        return this.compose(FastMath.acos(this.f0), mS, mS * this.f0 * inv);
    }

    @Override
    public UnivariateDerivative2 asin() {
        double inv = 1.0 / (1.0 - this.f0 * this.f0);
        double s = FastMath.sqrt(inv);
        return this.compose(FastMath.asin(this.f0), s, s * this.f0 * inv);
    }

    @Override
    public UnivariateDerivative2 atan() {
        double inv = 1.0 / (1.0 + this.f0 * this.f0);
        return this.compose(FastMath.atan(this.f0), inv, -2.0 * this.f0 * inv * inv);
    }

    @Override
    public UnivariateDerivative2 atan2(UnivariateDerivative2 x) {
        double atan0 = FastMath.atan2(this.f0, x.f0);
        UnivariateDerivative2 result = x.getValue() != 0.0 ? this.divide(x).atan() : x.divide(this).negate().atan();
        return new UnivariateDerivative2(atan0, result.f1, result.f2);
    }

    @Override
    public UnivariateDerivative2 cosh() {
        double c = FastMath.cosh(this.f0);
        double s = FastMath.sinh(this.f0);
        return this.compose(c, s, c);
    }

    @Override
    public UnivariateDerivative2 sinh() {
        double c = FastMath.cosh(this.f0);
        double s = FastMath.sinh(this.f0);
        return this.compose(s, c, s);
    }

    @Override
    public FieldSinhCosh<UnivariateDerivative2> sinhCosh() {
        SinhCosh sinhCosh = FastMath.sinhCosh(this.f0);
        return new FieldSinhCosh<UnivariateDerivative2>(this.compose(sinhCosh.sinh(), sinhCosh.cosh(), sinhCosh.sinh()), this.compose(sinhCosh.cosh(), sinhCosh.sinh(), sinhCosh.cosh()));
    }

    @Override
    public UnivariateDerivative2 tanh() {
        double tanh = FastMath.tanh(this.f0);
        double sech2 = 1.0 - tanh * tanh;
        return this.compose(tanh, sech2, -2.0 * sech2 * tanh);
    }

    @Override
    public UnivariateDerivative2 acosh() {
        double inv = 1.0 / (this.f0 * this.f0 - 1.0);
        double s = FastMath.sqrt(inv);
        return this.compose(FastMath.acosh(this.f0), s, -this.f0 * s * inv);
    }

    @Override
    public UnivariateDerivative2 asinh() {
        double inv = 1.0 / (this.f0 * this.f0 + 1.0);
        double s = FastMath.sqrt(inv);
        return this.compose(FastMath.asinh(this.f0), s, -this.f0 * s * inv);
    }

    @Override
    public UnivariateDerivative2 atanh() {
        double inv = 1.0 / (1.0 - this.f0 * this.f0);
        return this.compose(FastMath.atanh(this.f0), inv, 2.0 * this.f0 * inv * inv);
    }

    @Override
    public UnivariateDerivative2 toDegrees() {
        return new UnivariateDerivative2(FastMath.toDegrees(this.f0), FastMath.toDegrees(this.f1), FastMath.toDegrees(this.f2));
    }

    @Override
    public UnivariateDerivative2 toRadians() {
        return new UnivariateDerivative2(FastMath.toRadians(this.f0), FastMath.toRadians(this.f1), FastMath.toRadians(this.f2));
    }

    public double taylor(double delta) {
        return this.f0 + delta * (this.f1 + 0.5 * delta * this.f2);
    }

    public UnivariateDerivative2 linearCombination(UnivariateDerivative2[] a, UnivariateDerivative2[] b) {
        int n = a.length;
        double[] a0 = new double[n];
        double[] b0 = new double[n];
        double[] a1 = new double[2 * n];
        double[] b1 = new double[2 * n];
        double[] a2 = new double[3 * n];
        double[] b2 = new double[3 * n];
        for (int i = 0; i < n; ++i) {
            UnivariateDerivative2 ai = a[i];
            UnivariateDerivative2 bi = b[i];
            a0[i] = ai.f0;
            b0[i] = bi.f0;
            a1[2 * i] = ai.f0;
            a1[2 * i + 1] = ai.f1;
            b1[2 * i] = bi.f1;
            b1[2 * i + 1] = bi.f0;
            a2[3 * i] = ai.f0;
            a2[3 * i + 1] = ai.f1 + ai.f1;
            a2[3 * i + 2] = ai.f2;
            b2[3 * i] = bi.f2;
            b2[3 * i + 1] = bi.f1;
            b2[3 * i + 2] = bi.f0;
        }
        return new UnivariateDerivative2(MathArrays.linearCombination(a0, b0), MathArrays.linearCombination(a1, b1), MathArrays.linearCombination(a2, b2));
    }

    public UnivariateDerivative2 linearCombination(double[] a, UnivariateDerivative2[] b) {
        int n = b.length;
        double[] b0 = new double[n];
        double[] b1 = new double[n];
        double[] b2 = new double[n];
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].f0;
            b1[i] = b[i].f1;
            b2[i] = b[i].f2;
        }
        return new UnivariateDerivative2(MathArrays.linearCombination(a, b0), MathArrays.linearCombination(a, b1), MathArrays.linearCombination(a, b2));
    }

    @Override
    public UnivariateDerivative2 linearCombination(UnivariateDerivative2 a1, UnivariateDerivative2 b1, UnivariateDerivative2 a2, UnivariateDerivative2 b2) {
        return new UnivariateDerivative2(MathArrays.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0), MathArrays.linearCombination(a1.f0, b1.f1, a1.f1, b1.f0, a2.f0, b2.f1, a2.f1, b2.f0), MathArrays.linearCombination(new double[]{a1.f0, 2.0 * a1.f1, a1.f2, a2.f0, 2.0 * a2.f1, a2.f2}, new double[]{b1.f2, b1.f1, b1.f0, b2.f2, b2.f1, b2.f0}));
    }

    @Override
    public UnivariateDerivative2 linearCombination(double a1, UnivariateDerivative2 b1, double a2, UnivariateDerivative2 b2) {
        return new UnivariateDerivative2(MathArrays.linearCombination(a1, b1.f0, a2, b2.f0), MathArrays.linearCombination(a1, b1.f1, a2, b2.f1), MathArrays.linearCombination(a1, b1.f2, a2, b2.f2));
    }

    @Override
    public UnivariateDerivative2 linearCombination(UnivariateDerivative2 a1, UnivariateDerivative2 b1, UnivariateDerivative2 a2, UnivariateDerivative2 b2, UnivariateDerivative2 a3, UnivariateDerivative2 b3) {
        return new UnivariateDerivative2(MathArrays.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0, a3.f0, b3.f0), MathArrays.linearCombination(new double[]{a1.f0, a1.f1, a2.f0, a2.f1, a3.f0, a3.f1}, new double[]{b1.f1, b1.f0, b2.f1, b2.f0, b3.f1, b3.f0}), MathArrays.linearCombination(new double[]{a1.f0, 2.0 * a1.f1, a1.f2, a2.f0, 2.0 * a2.f1, a2.f2, a3.f0, 2.0 * a3.f1, a3.f2}, new double[]{b1.f2, b1.f1, b1.f0, b2.f2, b2.f1, b2.f0, b3.f2, b3.f1, b3.f0}));
    }

    @Override
    public UnivariateDerivative2 linearCombination(double a1, UnivariateDerivative2 b1, double a2, UnivariateDerivative2 b2, double a3, UnivariateDerivative2 b3) {
        return new UnivariateDerivative2(MathArrays.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0), MathArrays.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1), MathArrays.linearCombination(a1, b1.f2, a2, b2.f2, a3, b3.f2));
    }

    @Override
    public UnivariateDerivative2 linearCombination(UnivariateDerivative2 a1, UnivariateDerivative2 b1, UnivariateDerivative2 a2, UnivariateDerivative2 b2, UnivariateDerivative2 a3, UnivariateDerivative2 b3, UnivariateDerivative2 a4, UnivariateDerivative2 b4) {
        return new UnivariateDerivative2(MathArrays.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0, a3.f0, b3.f0, a4.f0, b4.f0), MathArrays.linearCombination(new double[]{a1.f0, a1.f1, a2.f0, a2.f1, a3.f0, a3.f1, a4.f0, a4.f1}, new double[]{b1.f1, b1.f0, b2.f1, b2.f0, b3.f1, b3.f0, b4.f1, b4.f0}), MathArrays.linearCombination(new double[]{a1.f0, 2.0 * a1.f1, a1.f2, a2.f0, 2.0 * a2.f1, a2.f2, a3.f0, 2.0 * a3.f1, a3.f2, a4.f0, 2.0 * a4.f1, a4.f2}, new double[]{b1.f2, b1.f1, b1.f0, b2.f2, b2.f1, b2.f0, b3.f2, b3.f1, b3.f0, b4.f2, b4.f1, b4.f0}));
    }

    @Override
    public UnivariateDerivative2 linearCombination(double a1, UnivariateDerivative2 b1, double a2, UnivariateDerivative2 b2, double a3, UnivariateDerivative2 b3, double a4, UnivariateDerivative2 b4) {
        return new UnivariateDerivative2(MathArrays.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0, a4, b4.f0), MathArrays.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1, a4, b4.f1), MathArrays.linearCombination(a1, b1.f2, a2, b2.f2, a3, b3.f2, a4, b4.f2));
    }

    @Override
    public UnivariateDerivative2 getPi() {
        return PI;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UnivariateDerivative2) {
            UnivariateDerivative2 rhs = (UnivariateDerivative2)other;
            return this.f0 == rhs.f0 && this.f1 == rhs.f1 && this.f2 == rhs.f2;
        }
        return false;
    }

    public int hashCode() {
        return 317 - 41 * Double.hashCode(this.f0) + 57 * Double.hashCode(this.f1) - 103 * Double.hashCode(this.f2);
    }

    @Override
    public int compareTo(UnivariateDerivative2 o) {
        int cF0 = Double.compare(this.f0, o.getReal());
        if (cF0 == 0) {
            int cF1 = Double.compare(this.f1, o.getFirstDerivative());
            if (cF1 == 0) {
                return Double.compare(this.f2, o.getSecondDerivative());
            }
            return cF1;
        }
        return cF0;
    }
}

