/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.io.Serializable;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;

public abstract class UnivariateDerivative<T extends UnivariateDerivative<T>>
implements Derivative<T>,
Serializable,
Comparable<T> {
    private static final long serialVersionUID = 20200519L;

    protected UnivariateDerivative() {
    }

    @Override
    public int getFreeParameters() {
        return 1;
    }

    @Override
    public double getPartialDerivative(int ... orders) throws MathIllegalArgumentException {
        if (orders.length != 1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, orders.length, 1);
        }
        return this.getDerivative(orders[0]);
    }

    public abstract double getDerivative(int var1) throws MathIllegalArgumentException;

    public abstract DerivativeStructure toDerivativeStructure();
}

