/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.hipparchus.util.SinhCosh;

public class DSCompiler {
    private static AtomicReference<DSCompiler[][]> compilers = new AtomicReference<Object>(null);
    private final int parameters;
    private final int order;
    private final int[][] sizes;
    private final int[][] derivativesOrders;
    private final int[] derivativesOrdersSum;
    private final int[] lowerIndirection;
    private final MultiplicationMapper[][] multIndirection;
    private final UnivariateCompositionMapper[][] compIndirection;
    private final List<MultivariateCompositionMapper[][]> rebaseIndirection;

    private DSCompiler(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler) throws MathIllegalArgumentException {
        this.parameters = parameters;
        this.order = order;
        this.sizes = DSCompiler.compileSizes(parameters, order, valueCompiler);
        this.derivativesOrders = DSCompiler.compileDerivativesOrders(parameters, order, valueCompiler, derivativeCompiler);
        this.derivativesOrdersSum = DSCompiler.compileDerivativesOrdersSum(this.derivativesOrders);
        this.lowerIndirection = DSCompiler.compileLowerIndirection(parameters, order, valueCompiler, derivativeCompiler);
        this.multIndirection = DSCompiler.compileMultiplicationIndirection(parameters, order, valueCompiler, derivativeCompiler, this.lowerIndirection);
        this.compIndirection = DSCompiler.compileCompositionIndirection(parameters, order, valueCompiler, derivativeCompiler, this.sizes, this.derivativesOrders);
        this.rebaseIndirection = new ArrayList<MultivariateCompositionMapper[][]>();
    }

    public static DSCompiler getCompiler(int parameters, int order) throws MathIllegalArgumentException {
        DSCompiler[][] cache = compilers.get();
        if (cache != null && cache.length > parameters && cache[parameters].length > order && cache[parameters][order] != null) {
            return cache[parameters][order];
        }
        int maxParameters = FastMath.max(parameters, cache == null ? 0 : cache.length);
        int maxOrder = FastMath.max(order, cache == null ? 0 : cache[0].length);
        DSCompiler[][] newCache = new DSCompiler[maxParameters + 1][maxOrder + 1];
        if (cache != null) {
            for (int i = 0; i < cache.length; ++i) {
                System.arraycopy(cache[i], 0, newCache[i], 0, cache[i].length);
            }
        }
        for (int diag = 0; diag <= parameters + order; ++diag) {
            for (int o = FastMath.max(0, diag - parameters); o <= FastMath.min(order, diag); ++o) {
                int p = diag - o;
                if (newCache[p][o] != null) continue;
                DSCompiler valueCompiler = p == 0 ? null : newCache[p - 1][o];
                DSCompiler derivativeCompiler = o == 0 ? null : newCache[p][o - 1];
                newCache[p][o] = new DSCompiler(p, o, valueCompiler, derivativeCompiler);
            }
        }
        compilers.compareAndSet(cache, newCache);
        return newCache[parameters][order];
    }

    private static int[][] compileSizes(int parameters, int order, DSCompiler valueCompiler) {
        int[][] sizes = new int[parameters + 1][order + 1];
        if (parameters == 0) {
            Arrays.fill(sizes[0], 1);
        } else {
            System.arraycopy(valueCompiler.sizes, 0, sizes, 0, parameters);
            sizes[parameters][0] = 1;
            for (int i = 0; i < order; ++i) {
                sizes[parameters][i + 1] = sizes[parameters][i] + sizes[parameters - 1][i + 1];
            }
        }
        return sizes;
    }

    private static int[][] compileDerivativesOrders(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler) {
        int i;
        if (parameters == 0 || order == 0) {
            return new int[1][parameters];
        }
        int vSize = valueCompiler.derivativesOrders.length;
        int dSize = derivativeCompiler.derivativesOrders.length;
        int[][] derivativesOrders = new int[vSize + dSize][parameters];
        for (i = 0; i < vSize; ++i) {
            System.arraycopy(valueCompiler.derivativesOrders[i], 0, derivativesOrders[i], 0, parameters - 1);
        }
        for (i = 0; i < dSize; ++i) {
            System.arraycopy(derivativeCompiler.derivativesOrders[i], 0, derivativesOrders[vSize + i], 0, parameters);
            int[] nArray = derivativesOrders[vSize + i];
            int n = parameters - 1;
            nArray[n] = nArray[n] + 1;
        }
        return derivativesOrders;
    }

    private static int[] compileDerivativesOrdersSum(int[][] derivativesOrders) {
        int[] derivativesOrdersSum = new int[derivativesOrders.length];
        for (int i = 0; i < derivativesOrdersSum.length; ++i) {
            for (int o : derivativesOrders[i]) {
                int n = i;
                derivativesOrdersSum[n] = derivativesOrdersSum[n] + o;
            }
        }
        return derivativesOrdersSum;
    }

    private static int[] compileLowerIndirection(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler) {
        if (parameters == 0 || order <= 1) {
            return new int[]{0};
        }
        int vSize = valueCompiler.lowerIndirection.length;
        int dSize = derivativeCompiler.lowerIndirection.length;
        int[] lowerIndirection = new int[vSize + dSize];
        System.arraycopy(valueCompiler.lowerIndirection, 0, lowerIndirection, 0, vSize);
        for (int i = 0; i < dSize; ++i) {
            lowerIndirection[vSize + i] = valueCompiler.getSize() + derivativeCompiler.lowerIndirection[i];
        }
        return lowerIndirection;
    }

    private static MultiplicationMapper[][] compileMultiplicationIndirection(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler, int[] lowerIndirection) {
        if (parameters == 0 || order == 0) {
            return new MultiplicationMapper[][]{{new MultiplicationMapper(1, 0, 0)}};
        }
        int vSize = valueCompiler.multIndirection.length;
        int dSize = derivativeCompiler.multIndirection.length;
        MultiplicationMapper[][] multIndirection = new MultiplicationMapper[vSize + dSize][];
        System.arraycopy(valueCompiler.multIndirection, 0, multIndirection, 0, vSize);
        for (int i = 0; i < dSize; ++i) {
            MultiplicationMapper[] dRow = derivativeCompiler.multIndirection[i];
            ArrayList<MultiplicationMapper> row = new ArrayList<MultiplicationMapper>(dRow.length * 2);
            for (MultiplicationMapper dj : dRow) {
                row.add(new MultiplicationMapper(dj.getCoeff(), lowerIndirection[dj.lhsIndex], vSize + dj.rhsIndex));
                row.add(new MultiplicationMapper(dj.getCoeff(), vSize + dj.lhsIndex, lowerIndirection[dj.rhsIndex]));
            }
            multIndirection[vSize + i] = (MultiplicationMapper[])DSCompiler.combineSimilarTerms(row);
        }
        return multIndirection;
    }

    private static UnivariateCompositionMapper[][] compileCompositionIndirection(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler, int[][] sizes, int[][] derivativesIndirection) throws MathIllegalArgumentException {
        if (parameters == 0 || order == 0) {
            return new UnivariateCompositionMapper[][]{{new UnivariateCompositionMapper(1, 0, new int[0])}};
        }
        int vSize = valueCompiler.compIndirection.length;
        int dSize = derivativeCompiler.compIndirection.length;
        UnivariateCompositionMapper[][] compIndirection = new UnivariateCompositionMapper[vSize + dSize][];
        System.arraycopy(valueCompiler.compIndirection, 0, compIndirection, 0, vSize);
        for (int i = 0; i < dSize; ++i) {
            ArrayList<UnivariateCompositionMapper> row = new ArrayList<UnivariateCompositionMapper>();
            for (UnivariateCompositionMapper term : derivativeCompiler.compIndirection[i]) {
                UnivariateCompositionMapper derivedTermF = new UnivariateCompositionMapper(term.getCoeff(), term.fIndex + 1, new int[term.dsIndices.length + 1]);
                int[] orders = new int[parameters];
                orders[parameters - 1] = 1;
                ((UnivariateCompositionMapper)derivedTermF).dsIndices[((UnivariateCompositionMapper)term).dsIndices.length] = DSCompiler.getPartialDerivativeIndex(parameters, order, sizes, orders);
                for (int j = 0; j < term.dsIndices.length; ++j) {
                    ((UnivariateCompositionMapper)derivedTermF).dsIndices[j] = DSCompiler.convertIndex(term.dsIndices[j], parameters, derivativeCompiler.derivativesOrders, parameters, order, sizes);
                }
                derivedTermF.sort();
                row.add(derivedTermF);
                for (int l = 0; l < term.dsIndices.length; ++l) {
                    UnivariateCompositionMapper derivedTermG = new UnivariateCompositionMapper(term.getCoeff(), term.fIndex, new int[term.dsIndices.length]);
                    for (int j = 0; j < term.dsIndices.length; ++j) {
                        ((UnivariateCompositionMapper)derivedTermG).dsIndices[j] = DSCompiler.convertIndex(term.dsIndices[j], parameters, derivativeCompiler.derivativesOrders, parameters, order, sizes);
                        if (j != l) continue;
                        System.arraycopy(derivativesIndirection[derivedTermG.dsIndices[j]], 0, orders, 0, parameters);
                        int n = parameters - 1;
                        orders[n] = orders[n] + 1;
                        ((UnivariateCompositionMapper)derivedTermG).dsIndices[j] = DSCompiler.getPartialDerivativeIndex(parameters, order, sizes, orders);
                    }
                    derivedTermG.sort();
                    row.add(derivedTermG);
                }
            }
            compIndirection[vSize + i] = (UnivariateCompositionMapper[])DSCompiler.combineSimilarTerms(row);
        }
        return compIndirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultivariateCompositionMapper[][] getRebaser(DSCompiler baseCompiler) {
        List<MultivariateCompositionMapper[][]> list = this.rebaseIndirection;
        synchronized (list) {
            int m = baseCompiler.getFreeParameters();
            while (this.rebaseIndirection.size() <= m) {
                this.rebaseIndirection.add(null);
            }
            if (this.rebaseIndirection.get(m) == null) {
                if (this.order == 0) {
                    MultivariateCompositionMapper[][] rebaser = new MultivariateCompositionMapper[][]{{new MultivariateCompositionMapper(1, 0, new int[0])}};
                    this.rebaseIndirection.set(m, rebaser);
                    return rebaser;
                }
                int baseSize = baseCompiler.getSize();
                MultivariateCompositionMapper[][] rebaser = this.initializeFromLowerRebaser(baseCompiler);
                for (int k = 1; k < baseSize; ++k) {
                    MultivariateCompositionMapper[] lowerRow;
                    if (rebaser[k] != null) continue;
                    ArrayList<MultivariateCompositionMapper> row = new ArrayList<MultivariateCompositionMapper>();
                    int[] orders = (int[])baseCompiler.derivativesOrders[k].clone();
                    int qIndex = -1;
                    for (int j = 0; j < orders.length; ++j) {
                        if (orders[j] <= 0) continue;
                        qIndex = j;
                        break;
                    }
                    int n = qIndex;
                    orders[n] = orders[n] - 1;
                    for (MultivariateCompositionMapper lowerTerm : lowerRow = rebaser[baseCompiler.getPartialDerivativeIndex(orders)]) {
                        for (int i = 0; i < this.parameters; ++i) {
                            row.add(this.differentiateFPart(lowerTerm, i, qIndex, baseCompiler));
                        }
                        for (int j = 0; j < lowerTerm.productIndices.length; ++j) {
                            row.add(this.differentiateProductPart(lowerTerm, j, qIndex, baseCompiler));
                        }
                    }
                    rebaser[k] = (MultivariateCompositionMapper[])DSCompiler.combineSimilarTerms(row);
                }
                this.rebaseIndirection.set(m, rebaser);
            }
            return this.rebaseIndirection.get(m);
        }
    }

    private MultivariateCompositionMapper[][] initializeFromLowerRebaser(DSCompiler baseCompiler) {
        DSCompiler lowerCompiler = DSCompiler.getCompiler(this.parameters, this.order - 1);
        DSCompiler lowerBaseCompiler = DSCompiler.getCompiler(baseCompiler.parameters, this.order - 1);
        int lowerBaseSize = lowerBaseCompiler.getSize();
        MultivariateCompositionMapper[][] lowerRebaser = lowerCompiler.getRebaser(lowerBaseCompiler);
        int baseSize = baseCompiler.getSize();
        MultivariateCompositionMapper[][] rebaser = new MultivariateCompositionMapper[baseSize][];
        for (int i = 0; i < lowerRebaser.length; ++i) {
            int index = DSCompiler.convertIndex(i, lowerBaseCompiler.parameters, lowerBaseCompiler.derivativesOrders, baseCompiler.parameters, baseCompiler.order, baseCompiler.sizes);
            rebaser[index] = new MultivariateCompositionMapper[lowerRebaser[i].length];
            for (int j = 0; j < rebaser[index].length; ++j) {
                int coeff = lowerRebaser[i][j].getCoeff();
                int dsIndex = DSCompiler.convertIndex(lowerRebaser[i][j].dsIndex, lowerCompiler.parameters, lowerCompiler.derivativesOrders, this.parameters, this.order, this.sizes);
                int[] productIndices = new int[lowerRebaser[i][j].productIndices.length];
                for (int k = 0; k < productIndices.length; ++k) {
                    int pIndex = lowerRebaser[i][j].productIndices[k] / lowerBaseSize;
                    int baseDSIndex = lowerRebaser[i][j].productIndices[k] % lowerBaseSize;
                    productIndices[k] = pIndex * baseSize + DSCompiler.convertIndex(baseDSIndex, lowerBaseCompiler.parameters, lowerBaseCompiler.derivativesOrders, baseCompiler.parameters, baseCompiler.order, baseCompiler.sizes);
                }
                rebaser[index][j] = new MultivariateCompositionMapper(coeff, dsIndex, productIndices);
            }
        }
        return rebaser;
    }

    private MultivariateCompositionMapper differentiateFPart(MultivariateCompositionMapper lowerTerm, int i, int qIndex, DSCompiler baseCompiler) {
        int[] termOrders = (int[])this.derivativesOrders[lowerTerm.dsIndex].clone();
        int n = i;
        termOrders[n] = termOrders[n] + 1;
        int fDSIndex = this.getPartialDerivativeIndex(termOrders);
        int[] productIndicesF = new int[lowerTerm.productIndices.length + 1];
        System.arraycopy(lowerTerm.productIndices, 0, productIndicesF, 0, lowerTerm.productIndices.length);
        int[] qOrders = new int[baseCompiler.parameters];
        qOrders[qIndex] = 1;
        productIndicesF[productIndicesF.length - 1] = i * baseCompiler.getSize() + baseCompiler.getPartialDerivativeIndex(qOrders);
        MultivariateCompositionMapper termF = new MultivariateCompositionMapper(lowerTerm.getCoeff(), fDSIndex, productIndicesF);
        termF.sort();
        return termF;
    }

    private MultivariateCompositionMapper differentiateProductPart(MultivariateCompositionMapper lowerTerm, int j, int qIndex, DSCompiler baseCompiler) {
        int baseSize = baseCompiler.getSize();
        int[] productIndicesP = (int[])lowerTerm.productIndices.clone();
        int pIndex = productIndicesP[j] / baseSize;
        int pDSIndex = productIndicesP[j] % baseSize;
        int[] pOrders = baseCompiler.getPartialDerivativeOrders(pDSIndex);
        int n = qIndex;
        pOrders[n] = pOrders[n] + 1;
        int pDSIndexHigherOrder = baseCompiler.getPartialDerivativeIndex(pOrders);
        productIndicesP[j] = pIndex * baseSize + pDSIndexHigherOrder;
        MultivariateCompositionMapper termP = new MultivariateCompositionMapper(lowerTerm.getCoeff(), lowerTerm.dsIndex, productIndicesP);
        termP.sort();
        return termP;
    }

    public int getPartialDerivativeIndex(int ... orders) throws MathIllegalArgumentException {
        MathUtils.checkDimension(orders.length, this.getFreeParameters());
        return DSCompiler.getPartialDerivativeIndex(this.parameters, this.order, this.sizes, orders);
    }

    private static int getPartialDerivativeIndex(int parameters, int order, int[][] sizes, int ... orders) throws MathIllegalArgumentException {
        int index = 0;
        int m = order;
        int ordersSum = 0;
        for (int i = parameters - 1; i >= 0; --i) {
            int derivativeOrder = orders[i];
            if ((ordersSum += derivativeOrder) > order) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, ordersSum, order);
            }
            while (derivativeOrder > 0) {
                --derivativeOrder;
                index += sizes[i][m--];
            }
        }
        return index;
    }

    private static int convertIndex(int index, int srcP, int[][] srcDerivativesOrders, int destP, int destO, int[][] destSizes) throws MathIllegalArgumentException {
        int[] orders = new int[destP];
        System.arraycopy(srcDerivativesOrders[index], 0, orders, 0, FastMath.min(srcP, destP));
        return DSCompiler.getPartialDerivativeIndex(destP, destO, destSizes, orders);
    }

    public int[] getPartialDerivativeOrders(int index) {
        return (int[])this.derivativesOrders[index].clone();
    }

    public int getPartialDerivativeOrdersSum(int index) {
        return this.derivativesOrdersSum[index];
    }

    public int getFreeParameters() {
        return this.parameters;
    }

    public int getOrder() {
        return this.order;
    }

    public int getSize() {
        return this.sizes[this.parameters][this.order];
    }

    public void linearCombination(double a1, double[] c1, int offset1, double a2, double[] c2, int offset2, double[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = MathArrays.linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i]);
        }
    }

    public <T extends CalculusFieldElement<T>> void linearCombination(T a1, T[] c1, int offset1, T a2, T[] c2, int offset2, T[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = (CalculusFieldElement)a1.linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i]);
        }
    }

    public <T extends CalculusFieldElement<T>> void linearCombination(double a1, T[] c1, int offset1, double a2, T[] c2, int offset2, T[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = (CalculusFieldElement)c1[offset1].linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i]);
        }
    }

    public void linearCombination(double a1, double[] c1, int offset1, double a2, double[] c2, int offset2, double a3, double[] c3, int offset3, double[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = MathArrays.linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i], a3, c3[offset3 + i]);
        }
    }

    public <T extends CalculusFieldElement<T>> void linearCombination(T a1, T[] c1, int offset1, T a2, T[] c2, int offset2, T a3, T[] c3, int offset3, T[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = (CalculusFieldElement)a1.linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i], a3, c3[offset3 + i]);
        }
    }

    public <T extends CalculusFieldElement<T>> void linearCombination(double a1, T[] c1, int offset1, double a2, T[] c2, int offset2, double a3, T[] c3, int offset3, T[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = (CalculusFieldElement)c1[offset1].linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i], a3, c3[offset3 + i]);
        }
    }

    public void linearCombination(double a1, double[] c1, int offset1, double a2, double[] c2, int offset2, double a3, double[] c3, int offset3, double a4, double[] c4, int offset4, double[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = MathArrays.linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i], a3, c3[offset3 + i], a4, c4[offset4 + i]);
        }
    }

    public <T extends CalculusFieldElement<T>> void linearCombination(T a1, T[] c1, int offset1, T a2, T[] c2, int offset2, T a3, T[] c3, int offset3, T a4, T[] c4, int offset4, T[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = (CalculusFieldElement)a1.linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i], a3, c3[offset3 + i], a4, c4[offset4 + i]);
        }
    }

    public <T extends CalculusFieldElement<T>> void linearCombination(double a1, T[] c1, int offset1, double a2, T[] c2, int offset2, double a3, T[] c3, int offset3, double a4, T[] c4, int offset4, T[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = (CalculusFieldElement)c1[offset1].linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i], a3, c3[offset3 + i], a4, c4[offset4 + i]);
        }
    }

    public void add(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = lhs[lhsOffset + i] + rhs[rhsOffset + i];
        }
    }

    public <T extends CalculusFieldElement<T>> void add(T[] lhs, int lhsOffset, T[] rhs, int rhsOffset, T[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = (CalculusFieldElement)lhs[lhsOffset + i].add(rhs[rhsOffset + i]);
        }
    }

    public void subtract(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = lhs[lhsOffset + i] - rhs[rhsOffset + i];
        }
    }

    public <T extends CalculusFieldElement<T>> void subtract(T[] lhs, int lhsOffset, T[] rhs, int rhsOffset, T[] result, int resultOffset) {
        for (int i = 0; i < this.getSize(); ++i) {
            result[resultOffset + i] = (CalculusFieldElement)lhs[lhsOffset + i].subtract(rhs[rhsOffset + i]);
        }
    }

    public void multiply(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        for (int i = 0; i < this.multIndirection.length; ++i) {
            double r = 0.0;
            for (MultiplicationMapper mapping : this.multIndirection[i]) {
                r += (double)mapping.getCoeff() * lhs[lhsOffset + mapping.lhsIndex] * rhs[rhsOffset + mapping.rhsIndex];
            }
            result[resultOffset + i] = r;
        }
    }

    public <T extends CalculusFieldElement<T>> void multiply(T[] lhs, int lhsOffset, T[] rhs, int rhsOffset, T[] result, int resultOffset) {
        CalculusFieldElement zero = (CalculusFieldElement)lhs[lhsOffset].getField().getZero();
        for (int i = 0; i < this.multIndirection.length; ++i) {
            CalculusFieldElement r = zero;
            for (MultiplicationMapper mapping : this.multIndirection[i]) {
                r = r.add((CalculusFieldElement)((CalculusFieldElement)lhs[lhsOffset + mapping.lhsIndex].multiply(rhs[rhsOffset + mapping.rhsIndex])).multiply(mapping.getCoeff()));
            }
            result[resultOffset + i] = r;
        }
    }

    public void divide(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        result[resultOffset] = lhs[lhsOffset] / rhs[rhsOffset];
        for (int i = 1; i < this.multIndirection.length; ++i) {
            result[resultOffset + i] = lhs[lhsOffset + i];
            for (int j = 0; j < this.multIndirection[i].length - 1; ++j) {
                MultiplicationMapper mapping = this.multIndirection[i][j];
                int n = resultOffset + i;
                result[n] = result[n] - (double)mapping.getCoeff() * (result[resultOffset + mapping.lhsIndex] * rhs[rhsOffset + mapping.rhsIndex]);
            }
            int n = resultOffset + i;
            result[n] = result[n] / (rhs[lhsOffset] * (double)this.multIndirection[i][0].getCoeff());
        }
    }

    public <T extends CalculusFieldElement<T>> void divide(T[] lhs, int lhsOffset, T[] rhs, int rhsOffset, T[] result, int resultOffset) {
        CalculusFieldElement zero = (CalculusFieldElement)lhs[lhsOffset].getField().getZero();
        result[resultOffset] = (CalculusFieldElement)lhs[lhsOffset].divide(rhs[rhsOffset]);
        for (int i = 1; i < this.multIndirection.length; ++i) {
            result[resultOffset + i] = lhs[lhsOffset + i].add((CalculusFieldElement)zero);
            for (int j = 0; j < this.multIndirection[i].length - 1; ++j) {
                MultiplicationMapper mapping = this.multIndirection[i][j];
                result[resultOffset + i] = result[resultOffset + i].subtract((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)result[resultOffset + mapping.lhsIndex].multiply(rhs[rhsOffset + mapping.rhsIndex])).multiply(mapping.getCoeff())));
            }
            result[resultOffset + i] = result[resultOffset + i].divide((CalculusFieldElement)((CalculusFieldElement)rhs[lhsOffset].multiply(this.multIndirection[i][0].getCoeff())));
        }
    }

    public void reciprocal(double[] operand, int operandOffset, double[] result, int resultOffset) {
        result[resultOffset] = 1.0 / operand[operandOffset];
        for (int i = 1; i < this.multIndirection.length; ++i) {
            result[resultOffset + i] = 0.0;
            for (int j = 0; j < this.multIndirection[i].length - 1; ++j) {
                MultiplicationMapper mapping = this.multIndirection[i][j];
                int n = resultOffset + i;
                result[n] = result[n] - (double)mapping.getCoeff() * (result[resultOffset + mapping.lhsIndex] * operand[operandOffset + mapping.rhsIndex]);
            }
            int n = resultOffset + i;
            result[n] = result[n] / (operand[operandOffset] * (double)this.multIndirection[i][0].getCoeff());
        }
    }

    public <T extends CalculusFieldElement<T>> void reciprocal(T[] operand, int operandOffset, T[] result, int resultOffset) {
        CalculusFieldElement zero = (CalculusFieldElement)operand[operandOffset].getField().getZero();
        result[resultOffset] = (CalculusFieldElement)operand[operandOffset].reciprocal();
        for (int i = 1; i < this.multIndirection.length; ++i) {
            result[resultOffset + i] = zero;
            for (int j = 0; j < this.multIndirection[i].length - 1; ++j) {
                MultiplicationMapper mapping = this.multIndirection[i][j];
                result[resultOffset + i] = result[resultOffset + i].subtract((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)result[resultOffset + mapping.lhsIndex].multiply(operand[operandOffset + mapping.rhsIndex])).multiply(mapping.getCoeff())));
            }
            result[resultOffset + i] = result[resultOffset + i].divide((CalculusFieldElement)((CalculusFieldElement)operand[operandOffset].multiply(this.multIndirection[i][0].getCoeff())));
        }
    }

    public void remainder(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        double rem = FastMath.IEEEremainder(lhs[lhsOffset], rhs[rhsOffset]);
        double k = FastMath.rint((lhs[lhsOffset] - rem) / rhs[rhsOffset]);
        result[resultOffset] = rem;
        for (int i = 1; i < this.getSize(); ++i) {
            result[resultOffset + i] = lhs[lhsOffset + i] - k * rhs[rhsOffset + i];
        }
    }

    public <T extends CalculusFieldElement<T>> void remainder(T[] lhs, int lhsOffset, T[] rhs, int rhsOffset, T[] result, int resultOffset) {
        CalculusFieldElement rem = (CalculusFieldElement)lhs[lhsOffset].remainder(rhs[rhsOffset]);
        double k = FastMath.rint((lhs[lhsOffset].getReal() - rem.getReal()) / rhs[rhsOffset].getReal());
        result[resultOffset] = rem;
        for (int i = 1; i < this.getSize(); ++i) {
            result[resultOffset + i] = lhs[lhsOffset + i].subtract((CalculusFieldElement)((CalculusFieldElement)rhs[rhsOffset + i].multiply(k)));
        }
    }

    public void pow(double a, double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        if (a == 0.0) {
            if (operand[operandOffset] == 0.0) {
                function[0] = 1.0;
                double infinity = Double.POSITIVE_INFINITY;
                for (int i = 1; i < function.length; ++i) {
                    function[i] = infinity = -infinity;
                }
            } else if (operand[operandOffset] < 0.0) {
                Arrays.fill(function, Double.NaN);
            }
        } else {
            function[0] = FastMath.pow(a, operand[operandOffset]);
            double lnA = FastMath.log(a);
            for (int i = 1; i < function.length; ++i) {
                function[i] = lnA * function[i - 1];
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void pow(double a, T[] operand, int operandOffset, T[] result, int resultOffset) {
        CalculusFieldElement zero = (CalculusFieldElement)operand[operandOffset].getField().getZero();
        Object[] function = (CalculusFieldElement[])MathArrays.buildArray(operand[operandOffset].getField(), (int)(1 + this.order));
        if (a == 0.0) {
            if (operand[operandOffset].getReal() == 0.0) {
                function[0] = (CalculusFieldElement)zero.add(1.0);
                CalculusFieldElement infinity = (CalculusFieldElement)zero.add(Double.POSITIVE_INFINITY);
                for (int i = 1; i < function.length; ++i) {
                    infinity = (CalculusFieldElement)infinity.negate();
                    function[i] = infinity;
                }
            } else if (operand[operandOffset].getReal() < 0.0) {
                Arrays.fill(function, zero.add(Double.NaN));
            }
        } else {
            function[0] = (CalculusFieldElement)((CalculusFieldElement)zero.add(a)).pow(operand[operandOffset]);
            double lnA = FastMath.log(a);
            for (int i = 1; i < function.length; ++i) {
                function[i] = (CalculusFieldElement)function[i - 1].multiply(lnA);
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, (CalculusFieldElement[])function, (CalculusFieldElement[])result, resultOffset);
    }

    public void pow(double[] operand, int operandOffset, double p, double[] result, int resultOffset) {
        if (p == 0.0) {
            result[resultOffset] = 1.0;
            Arrays.fill(result, resultOffset + 1, resultOffset + this.getSize(), 0.0);
            return;
        }
        if (operand[operandOffset] == 0.0) {
            Arrays.fill(result, resultOffset, resultOffset + this.getSize(), 0.0);
            return;
        }
        double[] function = new double[1 + this.order];
        double xk = FastMath.pow(operand[operandOffset], p - (double)this.order);
        for (int i = this.order; i > 0; --i) {
            function[i] = xk;
            xk *= operand[operandOffset];
        }
        function[0] = xk;
        double coefficient = p;
        for (int i = 1; i <= this.order; ++i) {
            int n = i;
            function[n] = function[n] * coefficient;
            coefficient *= p - (double)i;
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void pow(T[] operand, int operandOffset, double p, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        if (p == 0.0) {
            result[resultOffset] = (CalculusFieldElement)field.getOne();
            Arrays.fill(result, resultOffset + 1, resultOffset + this.getSize(), field.getZero());
            return;
        }
        if (operand[operandOffset].getReal() == 0.0) {
            Arrays.fill(result, resultOffset, resultOffset + this.getSize(), field.getZero());
            return;
        }
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        CalculusFieldElement xk = (CalculusFieldElement)operand[operandOffset].pow((double)(p - (double)this.order));
        for (int i = this.order; i > 0; --i) {
            function[i] = xk;
            xk = (CalculusFieldElement)xk.multiply(operand[operandOffset]);
        }
        function[0] = xk;
        double coefficient = p;
        for (int i = 1; i <= this.order; ++i) {
            function[i] = (CalculusFieldElement)function[i].multiply(coefficient);
            coefficient *= p - (double)i;
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void pow(double[] operand, int operandOffset, int n, double[] result, int resultOffset) {
        if (n == 0) {
            result[resultOffset] = 1.0;
            Arrays.fill(result, resultOffset + 1, resultOffset + this.getSize(), 0.0);
            return;
        }
        double[] function = new double[1 + this.order];
        if (n > 0) {
            int maxOrder = FastMath.min(this.order, n);
            double xk = FastMath.pow(operand[operandOffset], n - maxOrder);
            for (int i = maxOrder; i > 0; --i) {
                function[i] = xk;
                xk *= operand[operandOffset];
            }
            function[0] = xk;
        } else {
            double inv = 1.0 / operand[operandOffset];
            double xk = FastMath.pow(inv, -n);
            for (int i = 0; i <= this.order; ++i) {
                function[i] = xk;
                xk *= inv;
            }
        }
        double coefficient = n;
        for (int i = 1; i <= this.order; ++i) {
            int n2 = i;
            function[n2] = function[n2] * coefficient;
            coefficient *= (double)(n - i);
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void pow(T[] operand, int operandOffset, int n, T[] result, int resultOffset) {
        int i;
        CalculusFieldElement xk;
        Field field = operand[operandOffset].getField();
        if (n == 0) {
            result[resultOffset] = (CalculusFieldElement)field.getOne();
            Arrays.fill(result, resultOffset + 1, resultOffset + this.getSize(), field.getZero());
            return;
        }
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        if (n > 0) {
            int maxOrder = FastMath.min(this.order, n);
            xk = (CalculusFieldElement)operand[operandOffset].pow((int)(n - maxOrder));
            for (i = maxOrder; i > 0; --i) {
                function[i] = xk;
                xk = (CalculusFieldElement)xk.multiply(operand[operandOffset]);
            }
            function[0] = xk;
        } else {
            CalculusFieldElement inv = (CalculusFieldElement)operand[operandOffset].reciprocal();
            xk = (CalculusFieldElement)inv.pow(-n);
            for (i = 0; i <= this.order; ++i) {
                function[i] = xk;
                xk = xk.multiply(inv);
            }
        }
        double coefficient = n;
        for (i = 1; i <= this.order; ++i) {
            function[i] = (CalculusFieldElement)function[i].multiply(coefficient);
            coefficient *= (double)(n - i);
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void pow(double[] x, int xOffset, double[] y, int yOffset, double[] result, int resultOffset) {
        double[] logX = new double[this.getSize()];
        this.log(x, xOffset, logX, 0);
        double[] yLogX = new double[this.getSize()];
        this.multiply(logX, 0, y, yOffset, yLogX, 0);
        this.exp(yLogX, 0, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void pow(T[] x, int xOffset, T[] y, int yOffset, T[] result, int resultOffset) {
        CalculusFieldElement[] logX = (CalculusFieldElement[])MathArrays.buildArray(x[xOffset].getField(), (int)this.getSize());
        this.log((CalculusFieldElement[])x, xOffset, logX, 0);
        CalculusFieldElement[] yLogX = (CalculusFieldElement[])MathArrays.buildArray(x[xOffset].getField(), (int)this.getSize());
        this.multiply(logX, 0, (CalculusFieldElement[])y, yOffset, yLogX, 0);
        this.exp(yLogX, 0, (CalculusFieldElement[])result, resultOffset);
    }

    public void sqrt(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double sqrtConstant;
        result[resultOffset] = sqrtConstant = FastMath.sqrt(operand[operandOffset]);
        for (int i = 1; i < this.multIndirection.length; ++i) {
            result[resultOffset + i] = operand[operandOffset + i];
            for (int j = 1; j < this.multIndirection[i].length - 1; ++j) {
                MultiplicationMapper mapping = this.multIndirection[i][j];
                int n = resultOffset + i;
                result[n] = result[n] - (double)mapping.getCoeff() * (result[resultOffset + mapping.lhsIndex] * result[operandOffset + mapping.rhsIndex]);
            }
            int n = resultOffset + i;
            result[n] = result[n] / (sqrtConstant * (double)(this.multIndirection[i][this.multIndirection[i].length - 1].getCoeff() + this.multIndirection[i][0].getCoeff()));
        }
    }

    public <T extends CalculusFieldElement<T>> void sqrt(T[] operand, int operandOffset, T[] result, int resultOffset) {
        CalculusFieldElement zero = (CalculusFieldElement)operand[operandOffset].getField().getZero();
        CalculusFieldElement sqrtConstant = (CalculusFieldElement)operand[operandOffset].sqrt();
        result[resultOffset] = sqrtConstant.add(zero);
        for (int i = 1; i < this.multIndirection.length; ++i) {
            result[resultOffset + i] = operand[operandOffset + i].add((CalculusFieldElement)zero);
            for (int j = 1; j < this.multIndirection[i].length - 1; ++j) {
                MultiplicationMapper mapping = this.multIndirection[i][j];
                result[resultOffset + i] = result[resultOffset + i].subtract((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)result[resultOffset + mapping.lhsIndex].multiply(result[operandOffset + mapping.rhsIndex])).multiply(mapping.getCoeff())));
            }
            result[resultOffset + i] = result[resultOffset + i].divide((CalculusFieldElement)((CalculusFieldElement)sqrtConstant.multiply(this.multIndirection[i][0].getCoeff() + this.multIndirection[i][this.multIndirection[i].length - 1].getCoeff())));
        }
    }

    public void rootN(double[] operand, int operandOffset, int n, double[] result, int resultOffset) {
        double xk;
        double[] function = new double[1 + this.order];
        if (n == 2) {
            function[0] = FastMath.sqrt(operand[operandOffset]);
            xk = 0.5 / function[0];
        } else if (n == 3) {
            function[0] = FastMath.cbrt(operand[operandOffset]);
            xk = 1.0 / (3.0 * function[0] * function[0]);
        } else {
            function[0] = FastMath.pow(operand[operandOffset], 1.0 / (double)n);
            xk = 1.0 / ((double)n * FastMath.pow(function[0], n - 1));
        }
        double nReciprocal = 1.0 / (double)n;
        double xReciprocal = 1.0 / operand[operandOffset];
        for (int i = 1; i <= this.order; ++i) {
            function[i] = xk;
            xk *= xReciprocal * (nReciprocal - (double)i);
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void rootN(T[] operand, int operandOffset, int n, T[] result, int resultOffset) {
        CalculusFieldElement xk;
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        if (n == 2) {
            function[0] = (CalculusFieldElement)operand[operandOffset].sqrt();
            xk = (CalculusFieldElement)function[0].add(function[0]).reciprocal();
        } else if (n == 3) {
            function[0] = (CalculusFieldElement)operand[operandOffset].cbrt();
            xk = (CalculusFieldElement)((CalculusFieldElement)function[0].multiply(function[0]).multiply(3)).reciprocal();
        } else {
            function[0] = (CalculusFieldElement)operand[operandOffset].pow((double)(1.0 / (double)n));
            xk = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)function[0].pow(n - 1)).multiply(n)).reciprocal();
        }
        double nReciprocal = 1.0 / (double)n;
        CalculusFieldElement xReciprocal = (CalculusFieldElement)operand[operandOffset].reciprocal();
        for (int i = 1; i <= this.order; ++i) {
            function[i] = xk;
            xk = xk.multiply((CalculusFieldElement)xReciprocal.multiply(nReciprocal - (double)i));
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void exp(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        Arrays.fill(function, FastMath.exp(operand[operandOffset]));
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void exp(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        Object[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        Arrays.fill(function, operand[operandOffset].exp());
        this.compose((CalculusFieldElement[])operand, operandOffset, (CalculusFieldElement[])function, (CalculusFieldElement[])result, resultOffset);
    }

    public void expm1(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.expm1(operand[operandOffset]);
        Arrays.fill(function, 1, 1 + this.order, FastMath.exp(operand[operandOffset]));
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void expm1(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        Object[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        function[0] = (CalculusFieldElement)operand[operandOffset].expm1();
        Arrays.fill(function, 1, 1 + this.order, operand[operandOffset].exp());
        this.compose((CalculusFieldElement[])operand, operandOffset, (CalculusFieldElement[])function, (CalculusFieldElement[])result, resultOffset);
    }

    public void log(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.log(operand[operandOffset]);
        if (this.order > 0) {
            double inv;
            double xk = inv = 1.0 / operand[operandOffset];
            for (int i = 1; i <= this.order; ++i) {
                function[i] = xk;
                xk *= (double)(-i) * inv;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void log(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        function[0] = (CalculusFieldElement)operand[operandOffset].log();
        if (this.order > 0) {
            CalculusFieldElement inv;
            CalculusFieldElement xk = inv = (CalculusFieldElement)operand[operandOffset].reciprocal();
            for (int i = 1; i <= this.order; ++i) {
                function[i] = xk;
                xk = xk.multiply((CalculusFieldElement)inv.multiply(-i));
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void log1p(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.log1p(operand[operandOffset]);
        if (this.order > 0) {
            double inv;
            double xk = inv = 1.0 / (1.0 + operand[operandOffset]);
            for (int i = 1; i <= this.order; ++i) {
                function[i] = xk;
                xk *= (double)(-i) * inv;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void log1p(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        function[0] = (CalculusFieldElement)operand[operandOffset].log1p();
        if (this.order > 0) {
            CalculusFieldElement inv;
            CalculusFieldElement xk = inv = (CalculusFieldElement)((CalculusFieldElement)operand[operandOffset].add(1.0)).reciprocal();
            for (int i = 1; i <= this.order; ++i) {
                function[i] = xk;
                xk = xk.multiply((CalculusFieldElement)inv.multiply(-i));
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void log10(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.log10(operand[operandOffset]);
        if (this.order > 0) {
            double inv = 1.0 / operand[operandOffset];
            double xk = inv / FastMath.log(10.0);
            for (int i = 1; i <= this.order; ++i) {
                function[i] = xk;
                xk *= (double)(-i) * inv;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void log10(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        function[0] = (CalculusFieldElement)operand[operandOffset].log10();
        if (this.order > 0) {
            CalculusFieldElement inv = (CalculusFieldElement)operand[operandOffset].reciprocal();
            CalculusFieldElement xk = (CalculusFieldElement)inv.multiply(1.0 / FastMath.log(10.0));
            for (int i = 1; i <= this.order; ++i) {
                function[i] = xk;
                xk = xk.multiply((CalculusFieldElement)inv.multiply(-i));
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void cos(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        SinCos sinCos = FastMath.sinCos(operand[operandOffset]);
        function[0] = sinCos.cos();
        if (this.order > 0) {
            function[1] = -sinCos.sin();
            for (int i = 2; i <= this.order; ++i) {
                function[i] = -function[i - 2];
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void cos(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        FieldSinCos<T> sinCos = FastMath.sinCos(operand[operandOffset]);
        function[0] = (CalculusFieldElement)sinCos.cos();
        if (this.order > 0) {
            function[1] = (CalculusFieldElement)((CalculusFieldElement)sinCos.sin()).negate();
            if (this.order > 1) {
                function[2] = (CalculusFieldElement)((CalculusFieldElement)sinCos.cos()).negate();
                if (this.order > 2) {
                    function[3] = (CalculusFieldElement)sinCos.sin();
                    for (int i = 4; i <= this.order; ++i) {
                        function[i] = function[i - 4];
                    }
                }
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void sin(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        SinCos sinCos = FastMath.sinCos(operand[operandOffset]);
        function[0] = sinCos.sin();
        if (this.order > 0) {
            function[1] = sinCos.cos();
            for (int i = 2; i <= this.order; ++i) {
                function[i] = -function[i - 2];
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void sin(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        FieldSinCos<T> sinCos = FastMath.sinCos(operand[operandOffset]);
        function[0] = (CalculusFieldElement)sinCos.sin();
        if (this.order > 0) {
            function[1] = (CalculusFieldElement)sinCos.cos();
            if (this.order > 1) {
                function[2] = (CalculusFieldElement)((CalculusFieldElement)sinCos.sin()).negate();
                if (this.order > 2) {
                    function[3] = (CalculusFieldElement)((CalculusFieldElement)sinCos.cos()).negate();
                    for (int i = 4; i <= this.order; ++i) {
                        function[i] = function[i - 4];
                    }
                }
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void sinCos(double[] operand, int operandOffset, double[] sin, int sinOffset, double[] cos, int cosOffset) {
        double[] functionSin = new double[1 + this.order];
        double[] functionCos = new double[1 + this.order];
        SinCos sinCos = FastMath.sinCos(operand[operandOffset]);
        functionSin[0] = sinCos.sin();
        functionCos[0] = sinCos.cos();
        if (this.order > 0) {
            functionSin[1] = sinCos.cos();
            functionCos[1] = -sinCos.sin();
            for (int i = 2; i <= this.order; ++i) {
                functionSin[i] = -functionSin[i - 2];
                functionCos[i] = -functionCos[i - 2];
            }
        }
        this.compose(operand, operandOffset, functionSin, sin, sinOffset);
        this.compose(operand, operandOffset, functionCos, cos, cosOffset);
    }

    public <T extends CalculusFieldElement<T>> void sinCos(T[] operand, int operandOffset, T[] sin, int sinOffset, T[] cos, int cosOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] functionSin = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        CalculusFieldElement[] functionCos = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        FieldSinCos<T> sinCos = FastMath.sinCos(operand[operandOffset]);
        functionCos[0] = (CalculusFieldElement)sinCos.cos();
        if (this.order > 0) {
            functionCos[1] = (CalculusFieldElement)((CalculusFieldElement)sinCos.sin()).negate();
            if (this.order > 1) {
                functionCos[2] = (CalculusFieldElement)((CalculusFieldElement)sinCos.cos()).negate();
                if (this.order > 2) {
                    functionCos[3] = (CalculusFieldElement)sinCos.sin();
                    for (int i = 4; i <= this.order; ++i) {
                        functionCos[i] = functionCos[i - 4];
                    }
                }
            }
        }
        functionSin[0] = (CalculusFieldElement)sinCos.sin();
        System.arraycopy(functionCos, 0, functionSin, 1, this.order);
        this.compose((CalculusFieldElement[])operand, operandOffset, functionSin, (CalculusFieldElement[])sin, sinOffset);
        this.compose((CalculusFieldElement[])operand, operandOffset, functionCos, (CalculusFieldElement[])cos, cosOffset);
    }

    public void tan(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double t;
        double[] function = new double[1 + this.order];
        function[0] = t = FastMath.tan(operand[operandOffset]);
        if (this.order > 0) {
            double[] p = new double[this.order + 2];
            p[1] = 1.0;
            double t2 = t * t;
            for (int n = 1; n <= this.order; ++n) {
                double v = 0.0;
                p[n + 1] = (double)n * p[n];
                for (int k = n + 1; k >= 0; k -= 2) {
                    v = v * t2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] + (double)(k - 3) * p[k - 3];
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v *= t;
                }
                function[n] = v;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void tan(T[] operand, int operandOffset, T[] result, int resultOffset) {
        CalculusFieldElement t;
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        function[0] = t = (CalculusFieldElement)operand[operandOffset].tan();
        if (this.order > 0) {
            CalculusFieldElement[] p = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(this.order + 2));
            p[1] = (CalculusFieldElement)field.getOne();
            CalculusFieldElement t2 = t.multiply(t);
            for (int n = 1; n <= this.order; ++n) {
                CalculusFieldElement v = (CalculusFieldElement)field.getZero();
                p[n + 1] = (CalculusFieldElement)p[n].multiply(n);
                for (int k = n + 1; k >= 0; k -= 2) {
                    v = v.multiply(t2).add(p[k]);
                    if (k > 2) {
                        p[k - 2] = ((CalculusFieldElement)p[k - 1].multiply(k - 1)).add((CalculusFieldElement)p[k - 3].multiply(k - 3));
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v = v.multiply(t);
                }
                function[n] = v;
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void acos(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.acos(x);
        if (this.order > 0) {
            double[] p = new double[this.order];
            p[0] = -1.0;
            double x2 = x * x;
            double f = 1.0 / (1.0 - x2);
            double coeff = FastMath.sqrt(f);
            function[1] = coeff * p[0];
            for (int n = 2; n <= this.order; ++n) {
                double v = 0.0;
                p[n - 1] = (double)(n - 1) * p[n - 2];
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v * x2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] + (double)(2 * n - k) * p[k - 3];
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void acos(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        T x = operand[operandOffset];
        function[0] = (CalculusFieldElement)x.acos();
        if (this.order > 0) {
            CalculusFieldElement[] p = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.order);
            p[0] = (CalculusFieldElement)((CalculusFieldElement)field.getOne()).negate();
            CalculusFieldElement x2 = (CalculusFieldElement)x.square();
            CalculusFieldElement f = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.subtract(1.0)).negate()).reciprocal();
            CalculusFieldElement coeff = (CalculusFieldElement)f.sqrt();
            function[1] = coeff.multiply(p[0]);
            for (int n = 2; n <= this.order; ++n) {
                CalculusFieldElement v = (CalculusFieldElement)field.getZero();
                p[n - 1] = (CalculusFieldElement)p[n - 2].multiply(n - 1);
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v.multiply(x2).add(p[k]);
                    if (k > 2) {
                        p[k - 2] = ((CalculusFieldElement)p[k - 1].multiply(k - 1)).add((CalculusFieldElement)p[k - 3].multiply(2 * n - k));
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v = (CalculusFieldElement)v.multiply(x);
                }
                coeff = coeff.multiply(f);
                function[n] = coeff.multiply(v);
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void asin(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.asin(x);
        if (this.order > 0) {
            double[] p = new double[this.order];
            p[0] = 1.0;
            double x2 = x * x;
            double f = 1.0 / (1.0 - x2);
            double coeff = FastMath.sqrt(f);
            function[1] = coeff * p[0];
            for (int n = 2; n <= this.order; ++n) {
                double v = 0.0;
                p[n - 1] = (double)(n - 1) * p[n - 2];
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v * x2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] + (double)(2 * n - k) * p[k - 3];
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void asin(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        T x = operand[operandOffset];
        function[0] = (CalculusFieldElement)x.asin();
        if (this.order > 0) {
            CalculusFieldElement[] p = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.order);
            p[0] = (CalculusFieldElement)field.getOne();
            CalculusFieldElement x2 = (CalculusFieldElement)x.square();
            CalculusFieldElement f = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.subtract(1.0)).negate()).reciprocal();
            CalculusFieldElement coeff = (CalculusFieldElement)f.sqrt();
            function[1] = coeff.multiply(p[0]);
            for (int n = 2; n <= this.order; ++n) {
                CalculusFieldElement v = (CalculusFieldElement)field.getZero();
                p[n - 1] = (CalculusFieldElement)p[n - 2].multiply(n - 1);
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v.multiply(x2).add(p[k]);
                    if (k > 2) {
                        p[k - 2] = ((CalculusFieldElement)p[k - 1].multiply(k - 1)).add((CalculusFieldElement)p[k - 3].multiply(2 * n - k));
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v = (CalculusFieldElement)v.multiply(x);
                }
                coeff = coeff.multiply(f);
                function[n] = coeff.multiply(v);
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void atan(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.atan(x);
        if (this.order > 0) {
            double f;
            double[] q = new double[this.order];
            q[0] = 1.0;
            double x2 = x * x;
            double coeff = f = 1.0 / (1.0 + x2);
            function[1] = coeff * q[0];
            for (int n = 2; n <= this.order; ++n) {
                double v = 0.0;
                q[n - 1] = (double)(-n) * q[n - 2];
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v * x2 + q[k];
                    if (k > 2) {
                        q[k - 2] = (double)(k - 1) * q[k - 1] + (double)(k - 1 - 2 * n) * q[k - 3];
                        continue;
                    }
                    if (k != 2) continue;
                    q[0] = q[1];
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void atan(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        T x = operand[operandOffset];
        function[0] = (CalculusFieldElement)x.atan();
        if (this.order > 0) {
            CalculusFieldElement f;
            CalculusFieldElement[] q = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.order);
            q[0] = (CalculusFieldElement)field.getOne();
            CalculusFieldElement x2 = (CalculusFieldElement)x.square();
            CalculusFieldElement coeff = f = (CalculusFieldElement)((CalculusFieldElement)x2.add(1.0)).reciprocal();
            function[1] = coeff.multiply(q[0]);
            for (int n = 2; n <= this.order; ++n) {
                CalculusFieldElement v = (CalculusFieldElement)field.getZero();
                q[n - 1] = (CalculusFieldElement)q[n - 2].multiply(-n);
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v.multiply(x2).add(q[k]);
                    if (k > 2) {
                        q[k - 2] = ((CalculusFieldElement)q[k - 1].multiply(k - 1)).add((CalculusFieldElement)q[k - 3].multiply(k - 1 - 2 * n));
                        continue;
                    }
                    if (k != 2) continue;
                    q[0] = q[1];
                }
                if ((n & 1) == 0) {
                    v = (CalculusFieldElement)v.multiply(x);
                }
                coeff = coeff.multiply(f);
                function[n] = coeff.multiply(v);
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void atan2(double[] y, int yOffset, double[] x, int xOffset, double[] result, int resultOffset) {
        double[] tmp1 = new double[this.getSize()];
        this.multiply(x, xOffset, x, xOffset, tmp1, 0);
        double[] tmp2 = new double[this.getSize()];
        this.multiply(y, yOffset, y, yOffset, tmp2, 0);
        this.add(tmp1, 0, tmp2, 0, tmp2, 0);
        this.rootN(tmp2, 0, 2, tmp1, 0);
        if (x[xOffset] >= 0.0) {
            this.add(tmp1, 0, x, xOffset, tmp2, 0);
            this.divide(y, yOffset, tmp2, 0, tmp1, 0);
            this.atan(tmp1, 0, tmp2, 0);
            for (int i = 0; i < tmp2.length; ++i) {
                result[resultOffset + i] = 2.0 * tmp2[i];
            }
        } else {
            this.subtract(tmp1, 0, x, xOffset, tmp2, 0);
            this.divide(y, yOffset, tmp2, 0, tmp1, 0);
            this.atan(tmp1, 0, tmp2, 0);
            result[resultOffset] = (tmp2[0] <= 0.0 ? -Math.PI : Math.PI) - 2.0 * tmp2[0];
            for (int i = 1; i < tmp2.length; ++i) {
                result[resultOffset + i] = -2.0 * tmp2[i];
            }
        }
        result[resultOffset] = FastMath.atan2(y[yOffset], x[xOffset]);
    }

    public <T extends CalculusFieldElement<T>> void atan2(T[] y, int yOffset, T[] x, int xOffset, T[] result, int resultOffset) {
        Field field = y[yOffset].getField();
        CalculusFieldElement[] tmp1 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.getSize());
        this.multiply((CalculusFieldElement[])x, xOffset, (CalculusFieldElement[])x, xOffset, tmp1, 0);
        CalculusFieldElement[] tmp2 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.getSize());
        this.multiply((CalculusFieldElement[])y, yOffset, (CalculusFieldElement[])y, yOffset, tmp2, 0);
        this.add(tmp1, 0, tmp2, 0, tmp2, 0);
        this.rootN(tmp2, 0, 2, tmp1, 0);
        if (x[xOffset].getReal() >= 0.0) {
            this.add(tmp1, 0, (CalculusFieldElement[])x, xOffset, tmp2, 0);
            this.divide((CalculusFieldElement[])y, yOffset, tmp2, 0, tmp1, 0);
            this.atan(tmp1, 0, tmp2, 0);
            for (int i = 0; i < tmp2.length; ++i) {
                result[resultOffset + i] = tmp2[i].add(tmp2[i]);
            }
        } else {
            this.subtract(tmp1, 0, (CalculusFieldElement[])x, xOffset, tmp2, 0);
            this.divide((CalculusFieldElement[])y, yOffset, tmp2, 0, tmp1, 0);
            this.atan(tmp1, 0, tmp2, 0);
            result[resultOffset] = (CalculusFieldElement)((CalculusFieldElement)tmp2[0].add(tmp2[0]).negate()).add(tmp2[0].getReal() <= 0.0 ? -Math.PI : Math.PI);
            for (int i = 1; i < tmp2.length; ++i) {
                result[resultOffset + i] = (CalculusFieldElement)tmp2[i].add(tmp2[i]).negate();
            }
        }
        result[resultOffset] = (CalculusFieldElement)y[yOffset].atan2(x[xOffset]);
    }

    public void cosh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.cosh(operand[operandOffset]);
        if (this.order > 0) {
            function[1] = FastMath.sinh(operand[operandOffset]);
            for (int i = 2; i <= this.order; ++i) {
                function[i] = function[i - 2];
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void cosh(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        function[0] = (CalculusFieldElement)operand[operandOffset].cosh();
        if (this.order > 0) {
            function[1] = (CalculusFieldElement)operand[operandOffset].sinh();
            for (int i = 2; i <= this.order; ++i) {
                function[i] = function[i - 2];
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void sinh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.sinh(operand[operandOffset]);
        if (this.order > 0) {
            function[1] = FastMath.cosh(operand[operandOffset]);
            for (int i = 2; i <= this.order; ++i) {
                function[i] = function[i - 2];
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void sinh(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        function[0] = (CalculusFieldElement)operand[operandOffset].sinh();
        if (this.order > 0) {
            function[1] = (CalculusFieldElement)operand[operandOffset].cosh();
            for (int i = 2; i <= this.order; ++i) {
                function[i] = function[i - 2];
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void sinhCosh(double[] operand, int operandOffset, double[] sinh, int sinhOffset, double[] cosh, int coshOffset) {
        double[] functionSinh = new double[1 + this.order];
        double[] functionCosh = new double[1 + this.order];
        SinhCosh sinhCosh = FastMath.sinhCosh(operand[operandOffset]);
        functionSinh[0] = sinhCosh.sinh();
        functionCosh[0] = sinhCosh.cosh();
        if (this.order > 0) {
            functionSinh[1] = sinhCosh.cosh();
            functionCosh[1] = sinhCosh.sinh();
            for (int i = 2; i <= this.order; ++i) {
                functionSinh[i] = functionSinh[i - 2];
                functionCosh[i] = functionCosh[i - 2];
            }
        }
        this.compose(operand, operandOffset, functionSinh, sinh, sinhOffset);
        this.compose(operand, operandOffset, functionCosh, cosh, coshOffset);
    }

    public <T extends CalculusFieldElement<T>> void sinhCosh(T[] operand, int operandOffset, T[] sinh, int sinhOffset, T[] cosh, int coshOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] functionSinh = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        CalculusFieldElement[] functionCosh = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        FieldSinhCosh<T> sinhCosh = FastMath.sinhCosh(operand[operandOffset]);
        functionSinh[0] = (CalculusFieldElement)sinhCosh.sinh();
        functionCosh[0] = (CalculusFieldElement)sinhCosh.cosh();
        for (int i = 1; i <= this.order; ++i) {
            functionSinh[i] = functionCosh[i - 1];
            functionCosh[i] = functionSinh[i - 1];
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, functionSinh, (CalculusFieldElement[])sinh, sinhOffset);
        this.compose((CalculusFieldElement[])operand, operandOffset, functionCosh, (CalculusFieldElement[])cosh, coshOffset);
    }

    public void tanh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double t;
        double[] function = new double[1 + this.order];
        function[0] = t = FastMath.tanh(operand[operandOffset]);
        if (this.order > 0) {
            double[] p = new double[this.order + 2];
            p[1] = 1.0;
            double t2 = t * t;
            for (int n = 1; n <= this.order; ++n) {
                double v = 0.0;
                p[n + 1] = (double)(-n) * p[n];
                for (int k = n + 1; k >= 0; k -= 2) {
                    v = v * t2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] - (double)(k - 3) * p[k - 3];
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v *= t;
                }
                function[n] = v;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void tanh(T[] operand, int operandOffset, T[] result, int resultOffset) {
        CalculusFieldElement t;
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        function[0] = t = (CalculusFieldElement)operand[operandOffset].tanh();
        if (this.order > 0) {
            CalculusFieldElement[] p = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(this.order + 2));
            p[1] = (CalculusFieldElement)field.getOne();
            CalculusFieldElement t2 = t.multiply(t);
            for (int n = 1; n <= this.order; ++n) {
                CalculusFieldElement v = (CalculusFieldElement)field.getZero();
                p[n + 1] = (CalculusFieldElement)p[n].multiply(-n);
                for (int k = n + 1; k >= 0; k -= 2) {
                    v = v.multiply(t2).add(p[k]);
                    if (k > 2) {
                        p[k - 2] = ((CalculusFieldElement)p[k - 1].multiply(k - 1)).subtract((CalculusFieldElement)p[k - 3].multiply(k - 3));
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v = v.multiply(t);
                }
                function[n] = v;
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void acosh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.acosh(x);
        if (this.order > 0) {
            double[] p = new double[this.order];
            p[0] = 1.0;
            double x2 = x * x;
            double f = 1.0 / (x2 - 1.0);
            double coeff = FastMath.sqrt(f);
            function[1] = coeff * p[0];
            for (int n = 2; n <= this.order; ++n) {
                double v = 0.0;
                p[n - 1] = (double)(1 - n) * p[n - 2];
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v * x2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(1 - k) * p[k - 1] + (double)(k - 2 * n) * p[k - 3];
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = -p[1];
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void acosh(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        T x = operand[operandOffset];
        function[0] = (CalculusFieldElement)x.acosh();
        if (this.order > 0) {
            CalculusFieldElement[] p = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.order);
            p[0] = (CalculusFieldElement)field.getOne();
            CalculusFieldElement x2 = (CalculusFieldElement)x.square();
            CalculusFieldElement f = (CalculusFieldElement)((CalculusFieldElement)x2.subtract(1.0)).reciprocal();
            CalculusFieldElement coeff = (CalculusFieldElement)f.sqrt();
            function[1] = coeff.multiply(p[0]);
            for (int n = 2; n <= this.order; ++n) {
                CalculusFieldElement v = (CalculusFieldElement)field.getZero();
                p[n - 1] = (CalculusFieldElement)p[n - 2].multiply(1 - n);
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v.multiply(x2).add(p[k]);
                    if (k > 2) {
                        p[k - 2] = ((CalculusFieldElement)p[k - 1].multiply(1 - k)).add((CalculusFieldElement)p[k - 3].multiply(k - 2 * n));
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = (CalculusFieldElement)p[1].negate();
                }
                if ((n & 1) == 0) {
                    v = (CalculusFieldElement)v.multiply(x);
                }
                coeff = coeff.multiply(f);
                function[n] = coeff.multiply(v);
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void asinh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.asinh(x);
        if (this.order > 0) {
            double[] p = new double[this.order];
            p[0] = 1.0;
            double x2 = x * x;
            double f = 1.0 / (1.0 + x2);
            double coeff = FastMath.sqrt(f);
            function[1] = coeff * p[0];
            for (int n = 2; n <= this.order; ++n) {
                double v = 0.0;
                p[n - 1] = (double)(1 - n) * p[n - 2];
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v * x2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] + (double)(k - 2 * n) * p[k - 3];
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void asinh(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        T x = operand[operandOffset];
        function[0] = (CalculusFieldElement)x.asinh();
        if (this.order > 0) {
            CalculusFieldElement[] p = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.order);
            p[0] = (CalculusFieldElement)field.getOne();
            CalculusFieldElement x2 = (CalculusFieldElement)x.square();
            CalculusFieldElement f = (CalculusFieldElement)((CalculusFieldElement)x2.add(1.0)).reciprocal();
            CalculusFieldElement coeff = (CalculusFieldElement)f.sqrt();
            function[1] = coeff.multiply(p[0]);
            for (int n = 2; n <= this.order; ++n) {
                CalculusFieldElement v = (CalculusFieldElement)field.getZero();
                p[n - 1] = (CalculusFieldElement)p[n - 2].multiply(1 - n);
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v.multiply(x2).add(p[k]);
                    if (k > 2) {
                        p[k - 2] = ((CalculusFieldElement)p[k - 1].multiply(k - 1)).add((CalculusFieldElement)p[k - 3].multiply(k - 2 * n));
                        continue;
                    }
                    if (k != 2) continue;
                    p[0] = p[1];
                }
                if ((n & 1) == 0) {
                    v = (CalculusFieldElement)v.multiply(x);
                }
                coeff = coeff.multiply(f);
                function[n] = coeff.multiply(v);
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void atanh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.atanh(x);
        if (this.order > 0) {
            double f;
            double[] q = new double[this.order];
            q[0] = 1.0;
            double x2 = x * x;
            double coeff = f = 1.0 / (1.0 - x2);
            function[1] = coeff * q[0];
            for (int n = 2; n <= this.order; ++n) {
                double v = 0.0;
                q[n - 1] = (double)n * q[n - 2];
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v * x2 + q[k];
                    if (k > 2) {
                        q[k - 2] = (double)(k - 1) * q[k - 1] + (double)(2 * n - k + 1) * q[k - 3];
                        continue;
                    }
                    if (k != 2) continue;
                    q[0] = q[1];
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public <T extends CalculusFieldElement<T>> void atanh(T[] operand, int operandOffset, T[] result, int resultOffset) {
        Field field = operand[operandOffset].getField();
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(1 + this.order));
        T x = operand[operandOffset];
        function[0] = (CalculusFieldElement)x.atanh();
        if (this.order > 0) {
            CalculusFieldElement f;
            CalculusFieldElement[] q = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.order);
            q[0] = (CalculusFieldElement)field.getOne();
            CalculusFieldElement x2 = (CalculusFieldElement)x.square();
            CalculusFieldElement coeff = f = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.subtract(1.0)).negate()).reciprocal();
            function[1] = coeff.multiply(q[0]);
            for (int n = 2; n <= this.order; ++n) {
                CalculusFieldElement v = (CalculusFieldElement)field.getZero();
                q[n - 1] = (CalculusFieldElement)q[n - 2].multiply(n);
                for (int k = n - 1; k >= 0; k -= 2) {
                    v = v.multiply(x2).add(q[k]);
                    if (k > 2) {
                        q[k - 2] = ((CalculusFieldElement)q[k - 1].multiply(k - 1)).add((CalculusFieldElement)q[k - 3].multiply(2 * n - k + 1));
                        continue;
                    }
                    if (k != 2) continue;
                    q[0] = q[1];
                }
                if ((n & 1) == 0) {
                    v = (CalculusFieldElement)v.multiply(x);
                }
                coeff = coeff.multiply(f);
                function[n] = coeff.multiply(v);
            }
        }
        this.compose((CalculusFieldElement[])operand, operandOffset, function, (CalculusFieldElement[])result, resultOffset);
    }

    public void compose(double[] operand, int operandOffset, double[] f, double[] result, int resultOffset) {
        for (int i = 0; i < this.compIndirection.length; ++i) {
            UnivariateCompositionMapper[] mappingI = this.compIndirection[i];
            double r = 0.0;
            for (UnivariateCompositionMapper mapping : mappingI) {
                double product = (double)mapping.getCoeff() * f[mapping.fIndex];
                for (int k = 0; k < mapping.dsIndices.length; ++k) {
                    product *= operand[operandOffset + mapping.dsIndices[k]];
                }
                r += product;
            }
            result[resultOffset + i] = r;
        }
    }

    public <T extends CalculusFieldElement<T>> void compose(T[] operand, int operandOffset, T[] f, T[] result, int resultOffset) {
        CalculusFieldElement zero = (CalculusFieldElement)f[0].getField().getZero();
        for (int i = 0; i < this.compIndirection.length; ++i) {
            UnivariateCompositionMapper[] mappingI = this.compIndirection[i];
            CalculusFieldElement r = zero;
            for (UnivariateCompositionMapper mapping : mappingI) {
                CalculusFieldElement product = (CalculusFieldElement)f[mapping.fIndex].multiply(mapping.getCoeff());
                for (int k = 0; k < mapping.dsIndices.length; ++k) {
                    product = (CalculusFieldElement)product.multiply(operand[operandOffset + mapping.dsIndices[k]]);
                }
                r = r.add(product);
            }
            result[resultOffset + i] = r;
        }
    }

    public <T extends CalculusFieldElement<T>> void compose(T[] operand, int operandOffset, double[] f, T[] result, int resultOffset) {
        CalculusFieldElement zero = (CalculusFieldElement)operand[operandOffset].getField().getZero();
        for (int i = 0; i < this.compIndirection.length; ++i) {
            UnivariateCompositionMapper[] mappingI = this.compIndirection[i];
            CalculusFieldElement r = zero;
            for (UnivariateCompositionMapper mapping : mappingI) {
                CalculusFieldElement product = (CalculusFieldElement)zero.add(f[mapping.fIndex] * (double)mapping.getCoeff());
                for (int k = 0; k < mapping.dsIndices.length; ++k) {
                    product = (CalculusFieldElement)product.multiply(operand[operandOffset + mapping.dsIndices[k]]);
                }
                r = r.add(product);
            }
            result[resultOffset + i] = r;
        }
    }

    public double taylor(double[] ds, int dsOffset, double ... delta) throws MathRuntimeException {
        double value = 0.0;
        for (int i = this.getSize() - 1; i >= 0; --i) {
            int[] orders = this.derivativesOrders[i];
            double term = ds[dsOffset + i];
            for (int k = 0; k < orders.length; ++k) {
                if (orders[k] <= 0) continue;
                term *= FastMath.pow(delta[k], orders[k]) / (double)CombinatoricsUtils.factorial(orders[k]);
            }
            value += term;
        }
        return value;
    }

    @SafeVarargs
    public final <T extends CalculusFieldElement<T>> T taylor(T[] ds, int dsOffset, T ... delta) throws MathRuntimeException {
        Field field = ds[dsOffset].getField();
        CalculusFieldElement value = (CalculusFieldElement)field.getZero();
        for (int i = this.getSize() - 1; i >= 0; --i) {
            int[] orders = this.derivativesOrders[i];
            CalculusFieldElement term = ds[dsOffset + i];
            for (int k = 0; k < orders.length; ++k) {
                if (orders[k] <= 0) continue;
                term = term.multiply((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)delta[k].pow((int)orders[k])).divide((double)CombinatoricsUtils.factorial(orders[k]))));
            }
            value = (CalculusFieldElement)value.add(term);
        }
        return (T)value;
    }

    public <T extends CalculusFieldElement<T>> T taylor(T[] ds, int dsOffset, double ... delta) throws MathRuntimeException {
        Field field = ds[dsOffset].getField();
        CalculusFieldElement value = (CalculusFieldElement)field.getZero();
        for (int i = this.getSize() - 1; i >= 0; --i) {
            int[] orders = this.derivativesOrders[i];
            CalculusFieldElement term = ds[dsOffset + i];
            for (int k = 0; k < orders.length; ++k) {
                if (orders[k] <= 0) continue;
                term = term.multiply((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(delta[k])).pow(orders[k])).divide((double)CombinatoricsUtils.factorial(orders[k]))));
            }
            value = (CalculusFieldElement)value.add(term);
        }
        return (T)value;
    }

    public void rebase(double[] ds, int dsOffset, DSCompiler baseCompiler, double[] p, double[] result, int resultOffset) {
        MultivariateCompositionMapper[][] rebaser = this.getRebaser(baseCompiler);
        for (int i = 0; i < rebaser.length; ++i) {
            MultivariateCompositionMapper[] mappingI = rebaser[i];
            double r = 0.0;
            for (MultivariateCompositionMapper mapping : mappingI) {
                double product = (double)mapping.getCoeff() * ds[dsOffset + mapping.dsIndex];
                for (int k = 0; k < mapping.productIndices.length; ++k) {
                    product *= p[mapping.productIndices[k]];
                }
                r += product;
            }
            result[resultOffset + i] = r;
        }
    }

    public <T extends CalculusFieldElement<T>> void rebase(T[] ds, int dsOffset, DSCompiler baseCompiler, T[] p, T[] result, int resultOffset) {
        MultivariateCompositionMapper[][] rebaser = this.getRebaser(baseCompiler);
        for (int i = 0; i < rebaser.length; ++i) {
            MultivariateCompositionMapper[] mappingI = rebaser[i];
            CalculusFieldElement r = (CalculusFieldElement)ds[0].getField().getZero();
            for (MultivariateCompositionMapper mapping : mappingI) {
                CalculusFieldElement product = (CalculusFieldElement)ds[dsOffset + mapping.dsIndex].multiply(mapping.getCoeff());
                for (int k = 0; k < mapping.productIndices.length; ++k) {
                    product = (CalculusFieldElement)product.multiply(p[mapping.productIndices[k]]);
                }
                r = r.add(product);
            }
            result[resultOffset + i] = r;
        }
    }

    public void checkCompatibility(DSCompiler compiler) throws MathIllegalArgumentException {
        MathUtils.checkDimension(this.parameters, compiler.parameters);
        MathUtils.checkDimension(this.order, compiler.order);
    }

    private static <T extends AbstractMapper<T>> T[] combineSimilarTerms(List<T> terms) {
        ArrayList<AbstractMapper> combined = new ArrayList<AbstractMapper>(terms.size());
        for (int j = 0; j < terms.size(); ++j) {
            AbstractMapper termJ = (AbstractMapper)terms.get(j);
            if (termJ.getCoeff() <= 0) continue;
            for (int k = j + 1; k < terms.size(); ++k) {
                AbstractMapper termK = (AbstractMapper)terms.get(k);
                if (!termJ.isSimilar(termK)) continue;
                termJ.setCoeff(termJ.getCoeff() + termK.getCoeff());
                termK.setCoeff(0);
            }
            combined.add(termJ);
        }
        return combined.toArray((AbstractMapper[])Array.newInstance(((AbstractMapper)terms.get(0)).getClass(), combined.size()));
    }

    private static class MultivariateCompositionMapper
    extends AbstractMapper<MultivariateCompositionMapper> {
        private final int dsIndex;
        private final int[] productIndices;

        MultivariateCompositionMapper(int coeff, int dsIndex, int[] productIndices) {
            super(coeff);
            this.dsIndex = dsIndex;
            this.productIndices = (int[])productIndices.clone();
        }

        public void sort() {
            Arrays.sort(this.productIndices);
        }

        @Override
        public boolean isSimilar(MultivariateCompositionMapper other) {
            if (this.dsIndex == other.dsIndex && this.productIndices.length == other.productIndices.length) {
                for (int j = 0; j < this.productIndices.length; ++j) {
                    if (this.productIndices[j] == other.productIndices[j]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class UnivariateCompositionMapper
    extends AbstractMapper<UnivariateCompositionMapper> {
        private final int fIndex;
        private final int[] dsIndices;

        UnivariateCompositionMapper(int coeff, int fIndex, int[] dsIndices) {
            super(coeff);
            this.fIndex = fIndex;
            this.dsIndices = (int[])dsIndices.clone();
        }

        public void sort() {
            Arrays.sort(this.dsIndices);
        }

        @Override
        public boolean isSimilar(UnivariateCompositionMapper other) {
            if (this.fIndex == other.fIndex && this.dsIndices.length == other.dsIndices.length) {
                for (int j = 0; j < this.dsIndices.length; ++j) {
                    if (this.dsIndices[j] == other.dsIndices[j]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class MultiplicationMapper
    extends AbstractMapper<MultiplicationMapper> {
        private final int lhsIndex;
        private final int rhsIndex;

        MultiplicationMapper(int coeff, int lhsIndex, int rhsIndex) {
            super(coeff);
            this.lhsIndex = lhsIndex;
            this.rhsIndex = rhsIndex;
        }

        @Override
        public boolean isSimilar(MultiplicationMapper other) {
            return this.lhsIndex == other.lhsIndex && this.rhsIndex == other.rhsIndex;
        }
    }

    private static abstract class AbstractMapper<T extends AbstractMapper<T>> {
        private int coeff;

        AbstractMapper(int coeff) {
            this.coeff = coeff;
        }

        public void setCoeff(int coeff) {
            this.coeff = coeff;
        }

        public int getCoeff() {
            return this.coeff;
        }

        protected abstract boolean isSimilar(T var1);
    }
}

