/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.EigenDecompositionSymmetric;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.scalar.ObjectiveFunction;
import org.hipparchus.optim.nonlinear.vector.constrained.ADMMQPOptimizer;
import org.hipparchus.optim.nonlinear.vector.constrained.AbstractSQPOptimizer;
import org.hipparchus.optim.nonlinear.vector.constrained.LagrangeSolution;
import org.hipparchus.optim.nonlinear.vector.constrained.LinearEqualityConstraint;
import org.hipparchus.optim.nonlinear.vector.constrained.LinearInequalityConstraint;
import org.hipparchus.optim.nonlinear.vector.constrained.QuadraticFunction;
import org.hipparchus.util.FastMath;

public class SQPOptimizerGM
extends AbstractSQPOptimizer {
    private RealMatrix constraintJacob;
    private RealVector equalityEval;
    private RealVector inequalityEval;
    private RealVector functionGradient;
    private RealMatrix hessian;

    @Override
    public LagrangeSolution doOptimize() {
        int me = 0;
        int mi = 0;
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
        }
        if (this.getIqConstraint() != null) {
            mi = this.getIqConstraint().dimY();
        }
        ArrayRealVector x = this.getStartPoint() != null ? new ArrayRealVector(this.getStartPoint()) : new ArrayRealVector(this.getObj().dim());
        ArrayRealVector y = new ArrayRealVector(me + mi, 0.0);
        double functionEval = this.getObj().value((RealVector)x);
        this.functionGradient = this.getObj().gradient((RealVector)x);
        double maxGrad = this.functionGradient.getLInfNorm();
        if (this.getEqConstraint() != null) {
            this.equalityEval = this.getEqConstraint().value((RealVector)x);
        }
        if (this.getIqConstraint() != null) {
            this.inequalityEval = this.getIqConstraint().value((RealVector)x);
        }
        this.constraintJacob = this.computeJacobianConstraint((RealVector)x);
        if (this.getEqConstraint() != null) {
            maxGrad = FastMath.max((double)maxGrad, (double)this.equalityEval.getLInfNorm());
        }
        if (this.getIqConstraint() != null) {
            maxGrad = FastMath.max((double)maxGrad, (double)this.inequalityEval.getLInfNorm());
        }
        this.hessian = !this.getSettings().useFunHessian() ? MatrixUtils.createRealIdentityMatrix((int)x.getDimension()).scalarMultiply(maxGrad) : this.getObj().hessian((RealVector)x);
        double rho = 0.0;
        for (int i = 0; i < this.getMaxIterations(); ++i) {
            RealMatrix jacobi;
            this.iterations.increment();
            double alpha = 1.0;
            LagrangeSolution sol1 = this.solveQP((RealVector)x);
            RealVector p = sol1.getX();
            RealVector e = sol1.getLambda().subtract((RealVector)y);
            RealVector s = this.calculateSvector((RealVector)y, rho);
            ArrayRealVector se = null;
            RealVector q = null;
            ArrayRealVector qe = null;
            if (this.getEqConstraint() != null) {
                se = new ArrayRealVector(me);
                jacobi = this.constraintJacob.getSubMatrix(0, me - 1, 0, x.getDimension() - 1);
                qe = new ArrayRealVector(me);
            }
            if (this.getIqConstraint() != null) {
                jacobi = this.constraintJacob.getSubMatrix(me, me + mi - 1, 0, x.getDimension() - 1);
                q = jacobi.operate(p).add(this.inequalityEval.subtract(this.getIqConstraint().getLowerBound())).subtract(s);
            }
            double penaltyGradient = this.penaltyFunctionGrad(p, (RealVector)y, s, e, (RealVector)qe, q, rho);
            ArrayRealVector g = new ArrayRealVector(me + mi);
            if (me > 0) {
                g.setSubVector(0, this.equalityEval.subtract(this.getEqConstraint().getLowerBound()));
            }
            if (mi > 0) {
                g.setSubVector(me, this.inequalityEval.subtract(this.getIqConstraint().getLowerBound()).subtract(s));
            }
            double rhoSegnato = 2.0 * e.getNorm() / g.getNorm();
            while (penaltyGradient > -0.5 * p.dotProduct(this.hessian.operate(p))) {
                rho = FastMath.max((double)rhoSegnato, (double)(2.0 * rho));
                penaltyGradient = this.penaltyFunctionGrad(p, (RealVector)y, s, e, (RealVector)qe, q, rho);
            }
            double alfaEval = this.getObj().value(x.add(p.mapMultiply(alpha)));
            RealVector sineq = null;
            RealVector seq = null;
            if (se != null) {
                seq = se.add(qe.mapMultiply(alpha));
            }
            if (s != null) {
                sineq = s.add(q.mapMultiply(alpha));
            }
            double currentPenalty = this.penaltyFunction(functionEval, (RealVector)x, (RealVector)y, (RealVector)se, s, rho);
            double alphaPenalty = this.penaltyFunction(alfaEval, x.add(p.mapMultiply(alpha)), y.add(e.mapMultiply(alpha)), seq, sineq, rho);
            for (int search = 0; alphaPenalty - currentPenalty >= this.getSettings().getMu() * alpha * penaltyGradient && search < this.getSettings().getMaxLineSearchIteration(); ++search) {
                double alfaStar = -0.5 * alpha * alpha * penaltyGradient / (-alpha * penaltyGradient + alphaPenalty - currentPenalty);
                alpha = FastMath.max((double)(this.getSettings().getB() * alpha), (double)FastMath.min((double)1.0, (double)alfaStar));
                alfaEval = this.getObj().value(x.add(p.mapMultiply(alpha)));
                if (se != null) {
                    seq = se.add(qe.mapMultiply(alpha));
                }
                if (s != null) {
                    sineq = s.add(q.mapMultiply(alpha));
                }
                alphaPenalty = this.penaltyFunction(alfaEval, x.add(p.mapMultiply(alpha)), y.add(e.mapMultiply(alpha)), seq, sineq, rho);
            }
            if (this.getSettings().getConvCriteria() == 0 ? p.mapMultiply(alpha).dotProduct(this.hessian.operate(p.mapMultiply(alpha))) < this.getSettings().getEps() * this.getSettings().getEps() : alpha * p.getNorm() < FastMath.sqrt((double)this.getSettings().getEps()) * (1.0 + x.getNorm())) break;
            RealVector oldGradient = this.functionGradient;
            RealMatrix oldJacob = this.constraintJacob;
            RealVector old1 = this.lagrangianGradX(oldGradient, oldJacob, (RealVector)x, y.add(e.mapMultiply(alpha)));
            functionEval = alfaEval;
            this.functionGradient = this.getObj().gradient(x.add(p.mapMultiply(alpha)));
            this.constraintJacob = this.computeJacobianConstraint(x.add(p.mapMultiply(alpha)));
            RealVector new1 = this.lagrangianGradX(this.functionGradient, this.constraintJacob, x.add(p.mapMultiply(alpha)), y.add(e.mapMultiply(alpha)));
            this.hessian = this.BFGSFormula(this.hessian, p, alpha, new1, old1);
            if (this.getEqConstraint() != null) {
                this.equalityEval = this.getEqConstraint().value(x.add(p.mapMultiply(alpha)));
            }
            if (this.getIqConstraint() != null) {
                this.inequalityEval = this.getIqConstraint().value(x.add(p.mapMultiply(alpha)));
            }
            x = x.add(p.mapMultiply(alpha));
            y = y.add(e.mapMultiply(alpha));
        }
        functionEval = this.getObj().value((RealVector)x);
        this.functionGradient = this.getObj().gradient((RealVector)x);
        this.constraintJacob = this.computeJacobianConstraint((RealVector)x);
        return new LagrangeSolution((RealVector)x, (RealVector)y, functionEval);
    }

    private RealVector calculateSvector(RealVector y, double rho) {
        int me = 0;
        ArrayRealVector si = null;
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
        }
        if (this.getIqConstraint() != null) {
            int mi = this.getIqConstraint().dimY();
            si = new ArrayRealVector(mi);
            RealVector yi = y.getSubVector(me, mi);
            for (int i = 0; i < this.inequalityEval.getDimension(); ++i) {
                if (rho == 0.0) {
                    si.setEntry(i, FastMath.max((double)0.0, (double)this.inequalityEval.getEntry(i)));
                    continue;
                }
                si.setEntry(i, FastMath.max((double)0.0, (double)(this.inequalityEval.getEntry(i) - yi.getEntry(i) / rho)));
            }
        }
        return si;
    }

    private double penaltyFunction(double currentF, RealVector x, RealVector y, RealVector se, RealVector s, double rho) {
        RealVector g;
        int me = 0;
        double partial = currentF;
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
            RealVector ye = y.getSubVector(0, me);
            g = this.getEqConstraint().value(x).subtract(this.getEqConstraint().getLowerBound());
            partial += -ye.dotProduct(g.subtract(se)) + 0.5 * rho * g.subtract(se).dotProduct(g.subtract(se));
        }
        if (this.getIqConstraint() != null) {
            int mi = this.getIqConstraint().dimY();
            RealVector yi = y.getSubVector(me, mi);
            g = this.getIqConstraint().value(x).subtract(this.getIqConstraint().getLowerBound());
            partial += -yi.dotProduct(g.subtract(s)) + 0.5 * rho * g.subtract(s).dotProduct(g.subtract(s));
        }
        return partial;
    }

    private double penaltyFunctionGrad(RealVector p, RealVector y, RealVector s, RealVector e, RealVector qe, RealVector q, double rho) {
        double term6;
        double term5;
        double term4;
        double term3;
        double term2;
        RealMatrix jacob;
        int me = 0;
        double partial = this.functionGradient.dotProduct(p);
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
            RealVector ye = y.getSubVector(0, me);
            RealVector ee = e.getSubVector(0, me);
            RealVector ge = this.equalityEval.subtract(this.getEqConstraint().getLowerBound());
            jacob = this.constraintJacob.getSubMatrix(0, me - 1, 0, p.getDimension() - 1);
            term2 = p.dotProduct(jacob.transpose().operate(ye));
            term3 = p.dotProduct(jacob.transpose().operate(ge)) * rho;
            term4 = ge.dotProduct(ee);
            term5 = ye.dotProduct(qe);
            term6 = qe.dotProduct(ge) * rho;
            partial += -term2 + term3 - term4 + term5 - term6;
        }
        if (this.getIqConstraint() != null) {
            int mi = this.getIqConstraint().dimY();
            RealVector yi = y.getSubVector(me, mi);
            RealVector ei = e.getSubVector(me, mi);
            RealVector gi = this.inequalityEval.subtract(this.getIqConstraint().getLowerBound());
            jacob = this.constraintJacob.getSubMatrix(me, me + mi - 1, 0, p.getDimension() - 1);
            term2 = p.dotProduct(jacob.transpose().operate(yi));
            term3 = p.dotProduct(jacob.transpose().operate(gi.subtract(s))) * rho;
            term4 = gi.subtract(s).dotProduct(ei);
            term5 = yi.dotProduct(q);
            term6 = q.dotProduct(gi.subtract(s)) * rho;
            partial += -term2 + term3 - term4 + term5 - term6;
        }
        return partial;
    }

    private LagrangeSolution solveQP(RealVector x) {
        RealMatrix H = this.hessian;
        RealVector g = this.functionGradient;
        int me = 0;
        int mi = 0;
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
        }
        if (this.getIqConstraint() != null) {
            mi = this.getIqConstraint().dimY();
        }
        Array2DRowRealMatrix H1 = new Array2DRowRealMatrix(H.getRowDimension(), H.getRowDimension());
        H1.setSubMatrix(H.getData(), 0, 0);
        ArrayRealVector g1 = new ArrayRealVector(g.getDimension());
        g1.setSubVector(0, g);
        LinearEqualityConstraint eqc = null;
        if (this.getEqConstraint() != null) {
            RealMatrix eqJacob = this.constraintJacob.getSubMatrix(0, me - 1, 0, x.getDimension() - 1);
            Array2DRowRealMatrix Ae = new Array2DRowRealMatrix(me, x.getDimension());
            ArrayRealVector be = new ArrayRealVector(me);
            Ae.setSubMatrix(eqJacob.getData(), 0, 0);
            be.setSubVector(0, this.getEqConstraint().getLowerBound().subtract(this.equalityEval));
            eqc = new LinearEqualityConstraint((RealMatrix)Ae, (RealVector)be);
        }
        LinearInequalityConstraint iqc = null;
        if (this.getIqConstraint() != null) {
            RealMatrix iqJacob = this.constraintJacob.getSubMatrix(me, me + mi - 1, 0, x.getDimension() - 1);
            Array2DRowRealMatrix Ai = new Array2DRowRealMatrix(mi, x.getDimension());
            ArrayRealVector bi = new ArrayRealVector(mi);
            Ai.setSubMatrix(iqJacob.getData(), 0, 0);
            bi.setSubVector(0, this.getIqConstraint().getLowerBound().subtract(this.inequalityEval));
            iqc = new LinearInequalityConstraint((RealMatrix)Ai, (RealVector)bi);
        }
        QuadraticFunction q = new QuadraticFunction((RealMatrix)H1, (RealVector)g1, 0.0);
        ADMMQPOptimizer solver = new ADMMQPOptimizer();
        LagrangeSolution sol = solver.optimize(new ObjectiveFunction(q), iqc, eqc);
        return new LagrangeSolution(sol.getX(), sol.getLambda(), 0.0);
    }

    private RealMatrix computeJacobianConstraint(RealVector x) {
        int me = 0;
        int mi = 0;
        RealMatrix je = null;
        RealMatrix ji = null;
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
            je = this.getEqConstraint().jacobian(x);
        }
        if (this.getIqConstraint() != null) {
            mi = this.getIqConstraint().dimY();
            ji = this.getIqConstraint().jacobian(x);
        }
        Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(me + mi, x.getDimension());
        if (me > 0) {
            jacobian.setSubMatrix(je.getData(), 0, 0);
        }
        if (mi > 0) {
            jacobian.setSubMatrix(ji.getData(), me, 0);
        }
        return jacobian;
    }

    private RealMatrix BFGSFormula(RealMatrix oldH, RealVector dx, double alfa, RealVector newGrad, RealVector oldGrad) {
        RealMatrix oldH1 = oldH;
        RealVector y1 = newGrad.subtract(oldGrad);
        RealVector s = dx.mapMultiply(alfa);
        double theta = 1.0;
        if (s.dotProduct(y1) <= 0.2 * s.dotProduct(oldH.operate(s))) {
            theta = 0.8 * s.dotProduct(oldH.operate(s)) / (s.dotProduct(oldH.operate(s)) - s.dotProduct(y1));
        }
        RealVector y = y1.mapMultiply(theta).add(oldH.operate(s).mapMultiply(1.0 - theta));
        RealMatrix firstTerm = y.outerProduct(y).scalarMultiply(1.0 / s.dotProduct(y));
        RealMatrix secondTerm = oldH1.multiply(s.outerProduct(s)).multiply(oldH);
        double thirtTerm = s.dotProduct(oldH1.operate(s));
        RealMatrix Hnew = oldH1.add(firstTerm).subtract(secondTerm.scalarMultiply(1.0 / thirtTerm));
        EigenDecompositionSymmetric dsX = new EigenDecompositionSymmetric(Hnew);
        double min = new ArrayRealVector(dsX.getEigenvalues()).getMinValue();
        ArrayRealVector arrayRealVector = new ArrayRealVector(dsX.getEigenvalues());
        if (arrayRealVector.getMinValue() < 0.0) {
            RealMatrix diag = dsX.getD().add(MatrixUtils.createRealIdentityMatrix((int)dx.getDimension()).scalarMultiply(this.getSettings().getEps() - min));
            Hnew = dsX.getV().multiply(diag.multiply(dsX.getVT()));
        }
        return Hnew;
    }
}

