/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.optim.nonlinear.vector.constrained.EqualityConstraint;

public class LinearEqualityConstraint
extends EqualityConstraint
implements OptimizationData {
    private final RealMatrix a;

    public LinearEqualityConstraint(RealMatrix a, RealVector b) {
        super(b);
        this.a = a;
    }

    public LinearEqualityConstraint(double[][] a, double[] b) {
        this((RealMatrix)new Array2DRowRealMatrix(a), (RealVector)new ArrayRealVector(b));
    }

    public RealMatrix getA() {
        return this.a;
    }

    @Override
    public int dim() {
        return this.a.getColumnDimension();
    }

    @Override
    public RealVector value(RealVector x) {
        return this.a.operate(x);
    }

    @Override
    public RealMatrix jacobian(RealVector x) {
        return this.a.copy();
    }
}

