/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.LocalizedOptimFormats;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.optim.nonlinear.scalar.ObjectiveFunction;
import org.hipparchus.optim.nonlinear.vector.constrained.ConstraintOptimizer;
import org.hipparchus.optim.nonlinear.vector.constrained.EqualityConstraint;
import org.hipparchus.optim.nonlinear.vector.constrained.InequalityConstraint;
import org.hipparchus.optim.nonlinear.vector.constrained.LagrangeSolution;
import org.hipparchus.optim.nonlinear.vector.constrained.SQPOption;
import org.hipparchus.optim.nonlinear.vector.constrained.TwiceDifferentiableFunction;
import org.hipparchus.util.MathUtils;

public abstract class AbstractSQPOptimizer
extends ConstraintOptimizer {
    private SQPOption settings = new SQPOption();
    private TwiceDifferentiableFunction obj;
    private EqualityConstraint eqConstraint;
    private InequalityConstraint iqConstraint;

    protected AbstractSQPOptimizer() {
    }

    public SQPOption getSettings() {
        return this.settings;
    }

    public TwiceDifferentiableFunction getObj() {
        return this.obj;
    }

    public EqualityConstraint getEqConstraint() {
        return this.eqConstraint;
    }

    public InequalityConstraint getIqConstraint() {
        return this.iqConstraint;
    }

    @Override
    public LagrangeSolution optimize(OptimizationData ... optData) {
        return super.optimize(optData);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (data instanceof ObjectiveFunction) {
                this.obj = (TwiceDifferentiableFunction)((ObjectiveFunction)data).getObjectiveFunction();
                continue;
            }
            if (data instanceof EqualityConstraint) {
                this.eqConstraint = (EqualityConstraint)data;
                continue;
            }
            if (data instanceof InequalityConstraint) {
                this.iqConstraint = (InequalityConstraint)data;
                continue;
            }
            if (!(data instanceof SQPOption)) continue;
            this.settings = (SQPOption)data;
        }
        int n = this.obj.dim();
        if (this.eqConstraint != null) {
            int nDual = this.eqConstraint.dimY();
            if (nDual >= n) {
                throw new MathIllegalArgumentException((Localizable)LocalizedOptimFormats.CONSTRAINTS_RANK, new Object[]{nDual, n});
            }
            int nTest = this.eqConstraint.dim();
            if (nDual == 0) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.ZERO_NOT_ALLOWED, new Object[0]);
            }
            MathUtils.checkDimension((int)nTest, (int)n);
        }
    }

    protected RealVector lagrangianGradX(RealVector currentGrad, RealMatrix jacobConstraint, RealVector x, RealVector y) {
        RealVector firstTerm;
        int me = 0;
        RealVector partial = currentGrad.copy();
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
            RealVector ye = y.getSubVector(0, me);
            RealMatrix jacobe = jacobConstraint.getSubMatrix(0, me - 1, 0, x.getDimension() - 1);
            firstTerm = jacobe.transpose().operate(ye);
            partial = partial.subtract(firstTerm);
        }
        if (this.getIqConstraint() != null) {
            int mi = this.getIqConstraint().dimY();
            RealVector yi = y.getSubVector(me, mi);
            RealMatrix jacobi = jacobConstraint.getSubMatrix(me, me + mi - 1, 0, x.getDimension() - 1);
            firstTerm = jacobi.transpose().operate(yi);
            partial = partial.subtract(firstTerm);
        }
        return partial;
    }
}

