/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;

public class ADMMQPModifiedRuizEquilibrium {
    private static final double MIN_SCALING = 1.0E-6;
    private static final double MAX_SCALING = 1000000.0;
    private final RealMatrix H;
    private final RealVector q;
    private final RealMatrix A;
    private RealMatrix D;
    private RealMatrix E;
    private double c;
    private RealMatrix Dinv;
    private RealMatrix Einv;
    private double cinv;

    public ADMMQPModifiedRuizEquilibrium(RealMatrix H, RealMatrix A, RealVector q) {
        this.H = H;
        this.A = A;
        this.q = q;
    }

    public void normalize(double epsilon, int maxIteration) {
        this.c = 1.0;
        ArrayRealVector gammaD = new ArrayRealVector(this.H.getRowDimension());
        ArrayRealVector gammaE = new ArrayRealVector(this.A.getRowDimension());
        RealVector q1 = this.q.copy();
        RealMatrix H1 = this.H.copy();
        RealMatrix A1 = this.A.copy();
        RealMatrix SD = MatrixUtils.createRealIdentityMatrix((int)this.H.getRowDimension());
        RealMatrix SE = MatrixUtils.createRealIdentityMatrix((int)this.A.getRowDimension());
        ArrayRealVector H1norm = new ArrayRealVector(H1.getColumnDimension());
        for (int iteration = 0; iteration < maxIteration; ++iteration) {
            double norma;
            int i;
            for (i = 0; i < H1.getColumnDimension(); ++i) {
                norma = new ArrayRealVector(H1.getColumn(i), A1.getColumn(i)).getLInfNorm();
                gammaD.setEntry(i, norma);
            }
            for (i = 0; i < A1.getRowDimension(); ++i) {
                norma = A1.getRowVector(i).getLInfNorm();
                gammaE.setEntry(i, norma);
            }
            gammaD = this.limitScaling((RealVector)gammaD);
            gammaE = this.limitScaling((RealVector)gammaE);
            for (i = 0; i < gammaD.getDimension(); ++i) {
                gammaD.setEntry(i, 1.0 / FastMath.sqrt((double)gammaD.getEntry(i)));
            }
            for (i = 0; i < gammaE.getDimension(); ++i) {
                gammaE.setEntry(i, 1.0 / FastMath.sqrt((double)gammaE.getEntry(i)));
            }
            RealMatrix diagD = MatrixUtils.createRealDiagonalMatrix((double[])gammaD.toArray());
            RealMatrix diagE = MatrixUtils.createRealDiagonalMatrix((double[])gammaE.toArray());
            H1 = diagD.multiply(H1.copy()).multiply(diagD.copy());
            q1 = diagD.operate(q1.copy());
            A1 = diagE.multiply(A1.copy()).multiply(diagD.copy());
            for (i = 0; i < H1.getRowDimension(); ++i) {
                norma = new ArrayRealVector(H1.getRow(i)).getLInfNorm();
                H1norm.setEntry(i, norma);
            }
            double qnorm = q1.getLInfNorm();
            if (qnorm == 0.0) {
                qnorm = 1.0;
            }
            qnorm = this.limitScaling((RealVector)new ArrayRealVector(1, qnorm)).getEntry(0);
            double mean = 0.0;
            for (int i2 = 0; i2 < H1norm.getDimension(); ++i2) {
                mean += H1norm.getEntry(i2) / (double)H1norm.getDimension();
            }
            double lambda = 1.0 / this.limitScaling((RealVector)new ArrayRealVector(1, FastMath.max((double)mean, (double)qnorm))).getEntry(0);
            H1 = H1.copy().scalarMultiply(lambda);
            q1 = q1.copy().mapMultiply(lambda);
            this.c *= lambda;
            SD = diagD.multiply(SD.copy());
            SE = diagE.multiply(SE.copy());
        }
        this.E = SE.copy();
        this.D = SD.copy();
        this.Einv = MatrixUtils.inverse((RealMatrix)SE);
        this.Dinv = MatrixUtils.inverse((RealMatrix)SD);
        this.cinv = 1.0 / this.c;
    }

    public RealMatrix getScaledH() {
        return this.D.multiply(this.H).multiply(this.D).scalarMultiply(this.c);
    }

    public RealMatrix getScaledA() {
        return this.E.multiply(this.A).multiply(this.D);
    }

    public RealVector getScaledQ() {
        return this.D.operate(this.q.mapMultiply(this.c));
    }

    public RealVector getScaledLUb(RealVector lb1) {
        ArrayRealVector scaledLUb = new ArrayRealVector(lb1.getDimension());
        for (int i = 0; i < lb1.getDimension(); ++i) {
            if (lb1.getEntry(i) != Double.POSITIVE_INFINITY) {
                scaledLUb.setEntry(i, this.E.getEntry(i, i) * lb1.getEntry(i));
                continue;
            }
            scaledLUb.setEntry(i, Double.POSITIVE_INFINITY);
        }
        return scaledLUb;
    }

    public RealVector unscaleX(RealVector x) {
        return this.D.operate(x);
    }

    public RealVector unscaleY(RealVector y) {
        return this.E.operate(y).mapMultiply(this.cinv);
    }

    public RealVector unscaleZ(RealVector z) {
        return this.Einv.operate(z);
    }

    RealVector scaleX(RealVector x) {
        return this.Dinv.operate(x);
    }

    private RealVector limitScaling(RealVector v) {
        ArrayRealVector result = new ArrayRealVector(v.getDimension());
        for (int i = 0; i < v.getDimension(); ++i) {
            result.setEntry(i, v.getEntry(i) < 1.0E-6 ? 1.0 : v.getEntry(i));
            result.setEntry(i, v.getEntry(i) > 1000000.0 ? 1000000.0 : v.getEntry(i));
        }
        return result;
    }
}

