/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.optim.nonlinear.vector.constrained.LagrangeSolution;
import org.hipparchus.util.FastMath;

public class ADMMQPConvergenceChecker
implements ConvergenceChecker<LagrangeSolution>,
OptimizationData {
    private final RealMatrix h;
    private final RealMatrix a;
    private final RealVector q;
    private final double epsAbs;
    private final double epsRel;
    private boolean converged;

    ADMMQPConvergenceChecker(RealMatrix h, RealMatrix a, RealVector q, double epsAbs, double epsRel) {
        this.h = h;
        this.a = a;
        this.q = q;
        this.epsAbs = epsAbs;
        this.epsRel = epsRel;
        this.converged = false;
    }

    @Override
    public boolean converged(int i, LagrangeSolution previous, LagrangeSolution current) {
        return this.converged;
    }

    public boolean converged(double rp, double rd, double maxPrimal, double maxDual) {
        boolean result = false;
        if (rp <= this.epsPrimalDual(maxPrimal) && rd <= this.epsPrimalDual(maxDual)) {
            result = true;
            this.converged = true;
        }
        return result;
    }

    public double residualPrime(RealVector x, RealVector z) {
        return this.a.operate(x).subtract(z).getLInfNorm();
    }

    public double residualDual(RealVector x, RealVector y) {
        return this.q.add(this.a.transpose().operate(y)).add(this.h.operate(x)).getLInfNorm();
    }

    public double maxPrimal(RealVector x, RealVector z) {
        return FastMath.max((double)this.a.operate(x).getLInfNorm(), (double)z.getLInfNorm());
    }

    public double maxDual(RealVector x, RealVector y) {
        return FastMath.max((double)FastMath.max((double)this.h.operate(x).getLInfNorm(), (double)this.a.transpose().operate(y).getLInfNorm()), (double)this.q.getLInfNorm());
    }

    private double epsPrimalDual(double maxPrimalDual) {
        return this.epsAbs + this.epsRel * maxPrimalDual;
    }
}

