/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.SubHyperplane;

public class InteriorPointFinder<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>>
implements BSPTreeVisitor<S, P, H, I> {
    private final P defaultPoint;
    private BSPTree.InteriorPoint<S, P> selected;

    public InteriorPointFinder(P defaultPoint) {
        this.defaultPoint = defaultPoint;
        this.selected = null;
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<S, P, H, I> node) {
        return BSPTreeVisitor.Order.MINUS_PLUS_SUB;
    }

    @Override
    public void visitInternalNode(BSPTree<S, P, H, I> node) {
    }

    @Override
    public void visitLeafNode(BSPTree<S, P, H, I> node) {
        if (((Boolean)node.getAttribute()).booleanValue()) {
            BSPTree.InteriorPoint<S, P> interior = node.getInteriorPoint(this.defaultPoint);
            if (this.selected == null || interior.getDistance() > this.selected.getDistance()) {
                this.selected = interior;
            }
        }
    }

    public BSPTree.InteriorPoint<S, P> getPoint() {
        return this.selected;
    }
}

