/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationStage;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public enum RotationOrder {
    XYZ(RotationStage.X, RotationStage.Y, RotationStage.Z),
    XZY(RotationStage.X, RotationStage.Z, RotationStage.Y),
    YXZ(RotationStage.Y, RotationStage.X, RotationStage.Z),
    YZX(RotationStage.Y, RotationStage.Z, RotationStage.X),
    ZXY(RotationStage.Z, RotationStage.X, RotationStage.Y),
    ZYX(RotationStage.Z, RotationStage.Y, RotationStage.X),
    XYX(RotationStage.X, RotationStage.Y, RotationStage.X),
    XZX(RotationStage.X, RotationStage.Z, RotationStage.X),
    YXY(RotationStage.Y, RotationStage.X, RotationStage.Y),
    YZY(RotationStage.Y, RotationStage.Z, RotationStage.Y),
    ZXZ(RotationStage.Z, RotationStage.X, RotationStage.Z),
    ZYZ(RotationStage.Z, RotationStage.Y, RotationStage.Z);

    private static final double SAFE_SWITCH = 0.999;
    private final String name;
    private final RotationStage stage1;
    private final RotationStage stage2;
    private final RotationStage stage3;
    private final RotationStage missing;
    private final double sign;

    private RotationOrder(RotationStage stage1, RotationStage stage2, RotationStage stage3) {
        this.name = stage1.name() + stage2.name() + stage3.name();
        this.stage1 = stage1;
        this.stage2 = stage2;
        this.stage3 = stage3;
        this.missing = stage1 == stage3 ? (stage1 != RotationStage.X && stage2 != RotationStage.X ? RotationStage.X : (stage1 != RotationStage.Y && stage2 != RotationStage.Y ? RotationStage.Y : RotationStage.Z)) : null;
        Vector3D a1 = stage1.getAxis();
        Vector3D a2 = stage2.getAxis();
        Vector3D a3 = this.missing == null ? stage3.getAxis() : this.missing.getAxis();
        this.sign = FastMath.copySign((double)1.0, (double)Vector3D.dotProduct(a3, Vector3D.crossProduct(a1, a2)));
    }

    public String toString() {
        return this.name;
    }

    public Vector3D getA1() {
        return this.stage1.getAxis();
    }

    public Vector3D getA2() {
        return this.stage2.getAxis();
    }

    public Vector3D getA3() {
        return this.stage3.getAxis();
    }

    public static RotationOrder getRotationOrder(String value) {
        try {
            return RotationOrder.valueOf(value);
        }
        catch (IllegalArgumentException iae) {
            throw new MathIllegalStateException((Throwable)iae, (Localizable)LocalizedGeometryFormats.INVALID_ROTATION_ORDER_NAME, new Object[]{value});
        }
    }

    public double[] getAngles(Rotation rotation, RotationConvention convention) {
        double c;
        Vector3D vCol = this.getColumnVector(rotation, convention);
        Vector3D vRow = this.getRowVector(rotation, convention);
        if (this.missing == null) {
            double c2;
            if (convention == RotationConvention.FRAME_TRANSFORM) {
                double c3;
                double s = this.stage2.getComponent(vRow) * -this.sign;
                if (s * s + (c3 = this.stage3.getComponent(vRow)) * c3 > 1.0E-30) {
                    return new double[]{FastMath.atan2((double)s, (double)c3), RotationOrder.safeAsin(this.stage1.getComponent(vRow), this.stage2.getComponent(vRow), this.stage3.getComponent(vRow)) * this.sign, FastMath.atan2((double)(this.stage2.getComponent(vCol) * -this.sign), (double)this.stage1.getComponent(vCol))};
                }
                Vector3D midCol = rotation.applyTo(this.stage2.getAxis());
                return new double[]{0.0, FastMath.copySign((double)1.5707963267948966, (double)(this.stage1.getComponent(vRow) * this.sign)), FastMath.atan2((double)(this.stage1.getComponent(midCol) * this.sign), (double)this.stage2.getComponent(midCol))};
            }
            double s = this.stage2.getComponent(vCol) * -this.sign;
            if (s * s + (c2 = this.stage3.getComponent(vCol)) * c2 > 1.0E-30) {
                return new double[]{FastMath.atan2((double)s, (double)c2), RotationOrder.safeAsin(this.stage3.getComponent(vRow), this.stage1.getComponent(vRow), this.stage2.getComponent(vRow)) * this.sign, FastMath.atan2((double)(this.stage2.getComponent(vRow) * -this.sign), (double)this.stage1.getComponent(vRow))};
            }
            Vector3D midRow = rotation.applyInverseTo(this.stage2.getAxis());
            return new double[]{0.0, FastMath.copySign((double)1.5707963267948966, (double)(this.stage3.getComponent(vRow) * this.sign)), FastMath.atan2((double)(this.stage1.getComponent(midRow) * this.sign), (double)this.stage2.getComponent(midRow))};
        }
        if (convention == RotationConvention.FRAME_TRANSFORM) {
            double c4;
            double s = this.stage2.getComponent(vRow);
            if (s * s + (c4 = this.missing.getComponent(vRow) * -this.sign) * c4 > 1.0E-30) {
                return new double[]{FastMath.atan2((double)s, (double)c4), RotationOrder.safeAcos(this.stage1.getComponent(vRow), this.stage2.getComponent(vRow), this.missing.getComponent(vRow)), FastMath.atan2((double)this.stage2.getComponent(vCol), (double)(this.missing.getComponent(vCol) * this.sign))};
            }
            Vector3D midCol = rotation.applyTo(this.stage2.getAxis());
            return new double[]{FastMath.atan2((double)(this.missing.getComponent(midCol) * -this.sign), (double)this.stage2.getComponent(midCol)) * FastMath.copySign((double)1.0, (double)this.stage1.getComponent(vRow)), this.stage1.getComponent(vRow) > 0.0 ? 0.0 : Math.PI, 0.0};
        }
        double s = this.stage2.getComponent(vCol);
        if (s * s + (c = this.missing.getComponent(vCol) * -this.sign) * c > 1.0E-30) {
            return new double[]{FastMath.atan2((double)s, (double)c), RotationOrder.safeAcos(this.stage1.getComponent(vRow), this.stage2.getComponent(vRow), this.missing.getComponent(vRow)), FastMath.atan2((double)this.stage2.getComponent(vRow), (double)(this.missing.getComponent(vRow) * this.sign))};
        }
        Vector3D midRow = rotation.applyInverseTo(this.stage2.getAxis());
        return new double[]{FastMath.atan2((double)(this.missing.getComponent(midRow) * -this.sign), (double)this.stage2.getComponent(midRow)) * FastMath.copySign((double)1.0, (double)this.stage1.getComponent(vRow)), this.stage1.getComponent(vRow) > 0.0 ? 0.0 : Math.PI, 0.0};
    }

    public <T extends CalculusFieldElement<T>> T[] getAngles(FieldRotation<T> rotation, RotationConvention convention) {
        FieldVector3D<T> vCol = this.getColumnVector(rotation, convention);
        FieldVector3D<T> vRow = this.getRowVector(rotation, convention);
        if (this.missing == null) {
            if (convention == RotationConvention.FRAME_TRANSFORM) {
                CalculusFieldElement s = (CalculusFieldElement)this.stage2.getComponent(vRow).multiply(-this.sign);
                T c = this.stage3.getComponent(vRow);
                if (((CalculusFieldElement)((CalculusFieldElement)s.square()).add((FieldElement)((CalculusFieldElement)c.square()))).getReal() > 1.0E-30) {
                    return RotationOrder.buildArray((CalculusFieldElement)FastMath.atan2((CalculusFieldElement)s, c), (CalculusFieldElement)((CalculusFieldElement)RotationOrder.safeAsin(this.stage1.getComponent(vRow), this.stage2.getComponent(vRow), this.stage3.getComponent(vRow)).multiply(this.sign)), (CalculusFieldElement)FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)this.stage2.getComponent(vCol).multiply(-this.sign)), this.stage1.getComponent(vCol)));
                }
                FieldVector3D<T> midCol = rotation.applyTo(this.stage2.getAxis());
                return RotationOrder.buildArray((CalculusFieldElement)((CalculusFieldElement)s.getField().getZero()), (CalculusFieldElement)FastMath.copySign((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.getPi()).multiply(0.5)), (CalculusFieldElement)((CalculusFieldElement)this.stage1.getComponent(vRow).multiply(this.sign))), (CalculusFieldElement)FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)this.stage1.getComponent(midCol).multiply(this.sign)), this.stage2.getComponent(midCol)));
            }
            CalculusFieldElement s = (CalculusFieldElement)this.stage2.getComponent(vCol).multiply(-this.sign);
            T c = this.stage3.getComponent(vCol);
            if (((CalculusFieldElement)((CalculusFieldElement)s.square()).add((FieldElement)((CalculusFieldElement)c.square()))).getReal() > 1.0E-30) {
                return RotationOrder.buildArray((CalculusFieldElement)FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)this.stage2.getComponent(vCol).multiply(-this.sign)), this.stage3.getComponent(vCol)), (CalculusFieldElement)((CalculusFieldElement)RotationOrder.safeAsin(this.stage3.getComponent(vRow), this.stage1.getComponent(vRow), this.stage2.getComponent(vRow)).multiply(this.sign)), (CalculusFieldElement)FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)this.stage2.getComponent(vRow).multiply(-this.sign)), this.stage1.getComponent(vRow)));
            }
            FieldVector3D<T> midRow = rotation.applyInverseTo(this.stage2.getAxis());
            return RotationOrder.buildArray((CalculusFieldElement)((CalculusFieldElement)s.getField().getZero()), (CalculusFieldElement)FastMath.copySign((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.getPi()).multiply(0.5)), (CalculusFieldElement)((CalculusFieldElement)this.stage3.getComponent(vRow).multiply(this.sign))), (CalculusFieldElement)FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)this.stage1.getComponent(midRow).multiply(this.sign)), this.stage2.getComponent(midRow)));
        }
        if (convention == RotationConvention.FRAME_TRANSFORM) {
            T s = this.stage2.getComponent(vRow);
            CalculusFieldElement c = (CalculusFieldElement)this.missing.getComponent(vRow).multiply(-this.sign);
            if (((CalculusFieldElement)((CalculusFieldElement)s.square()).add((FieldElement)((CalculusFieldElement)c.square()))).getReal() > 1.0E-30) {
                return RotationOrder.buildArray((CalculusFieldElement)FastMath.atan2(s, (CalculusFieldElement)c), RotationOrder.safeAcos(this.stage1.getComponent(vRow), this.stage2.getComponent(vRow), this.missing.getComponent(vRow)), (CalculusFieldElement)FastMath.atan2(this.stage2.getComponent(vCol), (CalculusFieldElement)((CalculusFieldElement)this.missing.getComponent(vCol).multiply(this.sign))));
            }
            FieldVector3D<T> midCol = rotation.applyTo(this.stage2.getAxis());
            return RotationOrder.buildArray((CalculusFieldElement)((CalculusFieldElement)FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)this.missing.getComponent(midCol).multiply(-this.sign)), this.stage2.getComponent(midCol)).multiply(FastMath.copySign((double)1.0, (double)this.stage1.getComponent(vRow).getReal()))), (CalculusFieldElement)(this.stage1.getComponent(vRow).getReal() > 0.0 ? (CalculusFieldElement)s.getField().getZero() : (CalculusFieldElement)s.getPi()), (CalculusFieldElement)((CalculusFieldElement)s.getField().getZero()));
        }
        T s = this.stage2.getComponent(vCol);
        CalculusFieldElement c = (CalculusFieldElement)this.missing.getComponent(vCol).multiply(-this.sign);
        if (((CalculusFieldElement)((CalculusFieldElement)s.square()).add((FieldElement)((CalculusFieldElement)c.square()))).getReal() > 1.0E-30) {
            return RotationOrder.buildArray((CalculusFieldElement)FastMath.atan2(s, (CalculusFieldElement)c), RotationOrder.safeAcos(this.stage1.getComponent(vRow), this.stage2.getComponent(vRow), this.missing.getComponent(vRow)), (CalculusFieldElement)FastMath.atan2(this.stage2.getComponent(vRow), (CalculusFieldElement)((CalculusFieldElement)this.missing.getComponent(vRow).multiply(this.sign))));
        }
        FieldVector3D<T> midRow = rotation.applyInverseTo(this.stage2.getAxis());
        return RotationOrder.buildArray((CalculusFieldElement)((CalculusFieldElement)FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)this.missing.getComponent(midRow).multiply(-this.sign)), this.stage2.getComponent(midRow)).multiply(FastMath.copySign((double)1.0, (double)this.stage1.getComponent(vRow).getReal()))), (CalculusFieldElement)(this.stage1.getComponent(vRow).getReal() > 0.0 ? (CalculusFieldElement)s.getField().getZero() : (CalculusFieldElement)s.getPi()), (CalculusFieldElement)((CalculusFieldElement)s.getField().getZero()));
    }

    private Vector3D getColumnVector(Rotation rotation, RotationConvention convention) {
        return rotation.applyTo(convention == RotationConvention.VECTOR_OPERATOR ? this.stage3.getAxis() : this.stage1.getAxis());
    }

    private Vector3D getRowVector(Rotation rotation, RotationConvention convention) {
        return rotation.applyInverseTo(convention == RotationConvention.VECTOR_OPERATOR ? this.stage1.getAxis() : this.stage3.getAxis());
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> getColumnVector(FieldRotation<T> rotation, RotationConvention convention) {
        return rotation.applyTo(convention == RotationConvention.VECTOR_OPERATOR ? this.stage3.getAxis() : this.stage1.getAxis());
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> getRowVector(FieldRotation<T> rotation, RotationConvention convention) {
        return rotation.applyInverseTo(convention == RotationConvention.VECTOR_OPERATOR ? this.stage1.getAxis() : this.stage3.getAxis());
    }

    private static double safeAcos(double cos, double sin1, double sin2) {
        if (cos < -0.999) {
            return Math.PI - FastMath.asin((double)FastMath.sqrt((double)(sin1 * sin1 + sin2 * sin2)));
        }
        if (cos > 0.999) {
            return FastMath.asin((double)FastMath.sqrt((double)(sin1 * sin1 + sin2 * sin2)));
        }
        return FastMath.acos((double)cos);
    }

    private static double safeAsin(double sin, double cos1, double cos2) {
        if (sin < -0.999) {
            return -FastMath.acos((double)FastMath.sqrt((double)(cos1 * cos1 + cos2 * cos2)));
        }
        if (sin > 0.999) {
            return FastMath.acos((double)FastMath.sqrt((double)(cos1 * cos1 + cos2 * cos2)));
        }
        return FastMath.asin((double)sin);
    }

    private static <T extends CalculusFieldElement<T>> T safeAcos(T cos, T sin1, T sin2) {
        if (cos.getReal() < -0.999) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)FastMath.asin((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sin1.square()).add((FieldElement)((CalculusFieldElement)sin2.square()))))).subtract((FieldElement)((CalculusFieldElement)sin1.getPi()))).negate());
        }
        if (cos.getReal() > 0.999) {
            return (T)FastMath.asin((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sin1.square()).add((FieldElement)((CalculusFieldElement)sin2.square())))));
        }
        return (T)FastMath.acos(cos);
    }

    private static <T extends CalculusFieldElement<T>> T safeAsin(T sin, T cos1, T cos2) {
        if (sin.getReal() < -0.999) {
            return (T)((CalculusFieldElement)FastMath.acos((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cos1.square()).add((FieldElement)((CalculusFieldElement)cos2.square()))))).negate());
        }
        if (sin.getReal() > 0.999) {
            return (T)FastMath.acos((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cos1.square()).add((FieldElement)((CalculusFieldElement)cos2.square())))));
        }
        return (T)FastMath.asin(sin);
    }

    private static <T extends CalculusFieldElement<T>> T[] buildArray(T a0, T a1, T a2) {
        CalculusFieldElement[] array = (CalculusFieldElement[])MathArrays.buildArray((Field)a0.getField(), (int)3);
        array[0] = a0;
        array[1] = a1;
        array[2] = a2;
        return array;
    }
}

