/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples.geometry;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.enclosing.SupportBallGenerator;
import org.hipparchus.geometry.enclosing.WelzlEncloser;
import org.hipparchus.geometry.euclidean.twod.DiskGenerator;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.euclidean.twod.hull.ConvexHull2D;
import org.hipparchus.geometry.euclidean.twod.hull.MonotoneChain;
import org.hipparchus.random.MersenneTwister;
import org.hipparchus.samples.ExampleUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.piccolo2d.PCamera;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.event.PMouseWheelZoomEventHandler;
import org.piccolo2d.nodes.PPath;
import org.piccolo2d.nodes.PText;

public class GeometryExample {
    private static final String TOOLTIP = "tooltip";

    public static List<Vector2D> createRandomPoints(int size) {
        MersenneTwister random = new MersenneTwister();
        ArrayList<Vector2D> points = new ArrayList<Vector2D>(size);
        for (int i = 0; i < size; ++i) {
            points.add(new Vector2D((double)FastMath.round((double)(random.nextDouble() * 400.0 + 100.0)), (double)FastMath.round((double)(random.nextDouble() * 400.0 + 100.0))));
        }
        return points;
    }

    public static List<Vector2D> createCircle(int samples) {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        Vector2D center = new Vector2D(300.0, 300.0);
        double range = Math.PI * 2;
        double step = range / (double)(samples + 1);
        for (double angle = 0.0; angle < range; angle += step) {
            Vector2D circle = GeometryExample.buildVector(angle);
            points.add(circle.scalarMultiply(200.0).add(center));
        }
        return points;
    }

    public static List<Vector2D> createCross() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        for (int i = 100; i < 500; i += 10) {
            points.add(new Vector2D(300.0, (double)i));
            points.add(new Vector2D((double)i, 300.0));
        }
        return points;
    }

    public static PCanvas createCanvas() {
        PCanvas canvas = new PCanvas();
        final PCamera camera = canvas.getCamera();
        final PText tooltipNode = new PText();
        tooltipNode.setPickable(false);
        camera.addChild((PNode)tooltipNode);
        camera.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mouseMoved(PInputEvent event) {
                this.updateToolTip(event);
            }

            public void mouseDragged(PInputEvent event) {
                this.updateToolTip(event);
            }

            public void updateToolTip(PInputEvent event) {
                PNode n = event.getPickedNode();
                Object object = n.getAttribute((Object)GeometryExample.TOOLTIP);
                if (object != null) {
                    String tooltipString = object.toString();
                    Point2D p = event.getCanvasPosition();
                    event.getPath().canvasToLocal(p, (PNode)camera);
                    tooltipNode.setText(tooltipString);
                    tooltipNode.setOffset(p.getX() + 8.0, p.getY() - 8.0);
                } else {
                    tooltipNode.setText(null);
                }
            }
        });
        canvas.removeInputEventListener((PInputEventListener)canvas.getZoomEventHandler());
        PMouseWheelZoomEventHandler mouseWheelZoomEventHandler = new PMouseWheelZoomEventHandler();
        canvas.addInputEventListener((PInputEventListener)mouseWheelZoomEventHandler);
        return canvas;
    }

    private static Vector2D buildVector(double alpha) {
        SinCos sc = FastMath.sinCos((double)alpha);
        return new Vector2D(sc.cos(), sc.sin());
    }

    public static void main(String[] argv) {
        ExampleUtils.showExampleFrame(new Display());
    }

    public static class Display
    extends ExampleUtils.ExampleFrame {
        private List<Vector2D> points;
        private PCanvas canvas;
        private JComponent container;

        public Display() {
            this.setTitle("Hipparchus: Geometry Examples");
            this.setSize(800, 700);
            this.container = new JPanel(new BorderLayout());
            this.canvas = GeometryExample.createCanvas();
            this.container.add((Component)this.canvas);
            this.container.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            JPanel controlPanel = new JPanel();
            JButton random = new JButton("Randomize");
            controlPanel.add(random);
            random.addActionListener(e -> {
                this.canvas.getLayer().removeAllChildren();
                this.points = GeometryExample.createRandomPoints(1000);
                this.paintConvexHull();
            });
            JButton circle = new JButton("Circle");
            controlPanel.add(circle);
            circle.addActionListener(e -> {
                this.canvas.getLayer().removeAllChildren();
                this.points = GeometryExample.createCircle(100);
                this.paintConvexHull();
            });
            JButton cross = new JButton("Cross");
            controlPanel.add(cross);
            cross.addActionListener(e -> {
                this.canvas.getLayer().removeAllChildren();
                this.points = GeometryExample.createCross();
                this.paintConvexHull();
            });
            JSplitPane splitpane = new JSplitPane(1, this.container, controlPanel);
            splitpane.setDividerLocation(600);
            this.add(splitpane);
            this.points = GeometryExample.createRandomPoints(1000);
            this.paintConvexHull();
        }

        @Override
        public Component getMainPanel() {
            return this.container;
        }

        public void paintConvexHull() {
            PPath node;
            PNode pointSet = new PNode();
            for (Vector2D point : this.points) {
                PPath node2 = PPath.createEllipse((double)(point.getX() - 1.0), (double)(point.getY() - 1.0), (double)2.0, (double)2.0);
                node2.addAttribute((Object)GeometryExample.TOOLTIP, (Object)point);
                node2.setPaint((Paint)Color.gray);
                pointSet.addChild((PNode)node2);
            }
            this.canvas.getLayer().addChild(pointSet);
            MonotoneChain generator = new MonotoneChain(true, 1.0E-6);
            ConvexHull2D hull = generator.generate(this.points);
            PNode hullNode = new PNode();
            for (Vector2D vector2D : hull.getVertices()) {
                node = PPath.createEllipse((double)(vector2D.getX() - 1.0), (double)(vector2D.getY() - 1.0), (double)2.0, (double)2.0);
                node.addAttribute((Object)GeometryExample.TOOLTIP, (Object)vector2D);
                node.setPaint((Paint)Color.red);
                node.setStrokePaint((Paint)Color.red);
                hullNode.addChild((PNode)node);
            }
            for (Vector2D vector2D : hull.getLineSegments()) {
                node = PPath.createLine((double)vector2D.getStart().getX(), (double)vector2D.getStart().getY(), (double)vector2D.getEnd().getX(), (double)vector2D.getEnd().getY());
                node.setPickable(false);
                node.setPaint((Paint)Color.red);
                node.setStrokePaint((Paint)Color.red);
                hullNode.addChild((PNode)node);
            }
            this.canvas.getLayer().addChild(hullNode);
            WelzlEncloser encloser = new WelzlEncloser(1.0E-10, (SupportBallGenerator)new DiskGenerator());
            EnclosingBall ball = encloser.enclose(this.points);
            double radius = ball.getRadius();
            PPath ballCenter = PPath.createEllipse((double)(((Vector2D)ball.getCenter()).getX() - 1.0), (double)(((Vector2D)ball.getCenter()).getY() - 1.0), (double)2.0, (double)2.0);
            ballCenter.setStrokePaint((Paint)Color.blue);
            ballCenter.setPaint((Paint)Color.blue);
            this.canvas.getLayer().addChild(0, (PNode)ballCenter);
            PPath ballNode = PPath.createEllipse((double)(((Vector2D)ball.getCenter()).getX() - radius), (double)(((Vector2D)ball.getCenter()).getY() - radius), (double)(radius * 2.0), (double)(radius * 2.0));
            ballNode.setTransparency(1.0f);
            ballNode.setStrokePaint((Paint)Color.blue);
            this.canvas.getLayer().addChild(0, (PNode)ballNode);
        }
    }
}

