/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ExampleUtils {
    public static void showExampleFrame(ExampleFrame frame) {
        Runnable r = () -> {
            JMenuItem screenshot = new JMenuItem("Screenshot (png)");
            screenshot.setAccelerator(KeyStroke.getKeyStroke(48, 128));
            screenshot.addActionListener(ae -> {
                JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                if (fileChooser.showSaveDialog(frame) == 0) {
                    File file = fileChooser.getSelectedFile();
                    BufferedImage img = ExampleUtils.getScreenShot(frame.getMainPanel());
                    try {
                        ImageIO.write((RenderedImage)img, "png", file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            JMenuItem exit = new JMenuItem("Exit");
            exit.addActionListener(e -> System.exit(0));
            JMenu menu = new JMenu("File");
            menu.add(screenshot);
            menu.add(exit);
            JMenuBar mb = new JMenuBar();
            mb.add(menu);
            frame.setJMenuBar(mb);
            frame.setLocationRelativeTo(null);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        };
        SwingUtilities.invokeLater(r);
    }

    private static BufferedImage getScreenShot(Component component) {
        BufferedImage image = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        component.paint(image.getGraphics());
        return image;
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int width, int height, int type) {
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    public static class ExampleFrame
    extends JFrame {
        public Component getMainPanel() {
            return this.getContentPane();
        }
    }
}

