/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.sampling;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.sampling.FieldODEFixedStepHandler;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.ode.sampling.StepNormalizerBounds;
import org.hipparchus.ode.sampling.StepNormalizerMode;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

public class FieldStepNormalizer<T extends CalculusFieldElement<T>>
implements FieldODEStepHandler<T> {
    private double h;
    private final FieldODEFixedStepHandler<T> handler;
    private FieldODEStateAndDerivative<T> first;
    private FieldODEStateAndDerivative<T> last;
    private boolean forward;
    private final StepNormalizerBounds bounds;
    private final StepNormalizerMode mode;

    public FieldStepNormalizer(double h, FieldODEFixedStepHandler<T> handler) {
        this(h, handler, StepNormalizerMode.INCREMENT, StepNormalizerBounds.FIRST);
    }

    public FieldStepNormalizer(double h, FieldODEFixedStepHandler<T> handler, StepNormalizerMode mode) {
        this(h, handler, mode, StepNormalizerBounds.FIRST);
    }

    public FieldStepNormalizer(double h, FieldODEFixedStepHandler<T> handler, StepNormalizerBounds bounds) {
        this(h, handler, StepNormalizerMode.INCREMENT, bounds);
    }

    public FieldStepNormalizer(double h, FieldODEFixedStepHandler<T> handler, StepNormalizerMode mode, StepNormalizerBounds bounds) {
        this.h = FastMath.abs((double)h);
        this.handler = handler;
        this.mode = mode;
        this.bounds = bounds;
        this.first = null;
        this.last = null;
        this.forward = true;
    }

    @Override
    public void init(FieldODEStateAndDerivative<T> initialState, T finalTime) {
        this.first = null;
        this.last = null;
        this.forward = true;
        this.handler.init(initialState, finalTime);
    }

    @Override
    public void handleStep(FieldODEStateInterpolator<T> interpolator) {
        CalculusFieldElement nextTime;
        if (this.last == null) {
            this.first = interpolator.getPreviousState();
            this.last = this.first;
            this.forward = interpolator.isForward();
            if (!this.forward) {
                this.h = -this.h;
            }
        }
        CalculusFieldElement calculusFieldElement = nextTime = this.mode == StepNormalizerMode.INCREMENT ? (CalculusFieldElement)this.last.getTime().add(this.h) : (CalculusFieldElement)((CalculusFieldElement)this.last.getTime().getField().getZero()).add((FastMath.floor((double)(this.last.getTime().getReal() / this.h)) + 1.0) * this.h);
        if (this.mode == StepNormalizerMode.MULTIPLES && Precision.equals((double)nextTime.getReal(), (double)this.last.getTime().getReal(), (int)1)) {
            nextTime = (CalculusFieldElement)nextTime.add(this.h);
        }
        boolean nextInStep = this.isNextInStep(nextTime, interpolator);
        while (nextInStep) {
            this.doNormalizedStep(false);
            this.last = interpolator.getInterpolatedState(nextTime);
            nextTime = (CalculusFieldElement)nextTime.add(this.h);
            nextInStep = this.isNextInStep(nextTime, interpolator);
        }
    }

    @Override
    public void finish(FieldODEStateAndDerivative<T> finalState) {
        boolean addLast = this.bounds.lastIncluded() && this.last.getTime().getReal() != finalState.getTime().getReal();
        this.doNormalizedStep(!addLast);
        if (addLast) {
            this.last = finalState;
            this.doNormalizedStep(true);
        }
    }

    private boolean isNextInStep(T nextTime, FieldODEStateInterpolator<T> interpolator) {
        return this.forward ? nextTime.getReal() <= interpolator.getCurrentState().getTime().getReal() : nextTime.getReal() >= interpolator.getCurrentState().getTime().getReal();
    }

    private void doNormalizedStep(boolean isLast) {
        if (!this.bounds.firstIncluded() && this.first.getTime().getReal() == this.last.getTime().getReal()) {
            return;
        }
        this.handler.handleStep(this.last, isLast);
    }
}

