/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff.interpolators;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.interpolators.RungeKuttaStateInterpolator;

public class HighamHall54StateInterpolator
extends RungeKuttaStateInterpolator {
    private static final long serialVersionUID = 20111120L;

    public HighamHall54StateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected HighamHall54StateInterpolator create(boolean newForward, double[][] newYDotK, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new HighamHall54StateInterpolator(newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        double[] interpolatedDerivatives;
        double[] interpolatedState;
        double bDot0 = 1.0 + theta * (-7.5 + theta * (16.0 - 10.0 * theta));
        double bDot1 = 0.0;
        double bDot2 = theta * (28.6875 + theta * (-91.125 + 67.5 * theta));
        double bDot3 = theta * (-44.0 + theta * (152.0 - 120.0 * theta));
        double bDot4 = theta * (23.4375 + theta * (-78.125 + 62.5 * theta));
        double bDot5 = theta * 5.0 / 8.0 * (2.0 * theta - 1.0);
        if (this.getGlobalPreviousState() != null && theta <= 0.5) {
            double b0 = thetaH * (1.0 + theta * (-3.75 + theta * (5.333333333333333 - 2.5 * theta)));
            double b1 = 0.0;
            double b2 = thetaH * (theta * (14.34375 + theta * (-30.375 + theta * 135.0 / 8.0)));
            double b3 = thetaH * (theta * (-22.0 + theta * (50.666666666666664 + theta * -30.0)));
            double b4 = thetaH * (theta * (11.71875 + theta * (-26.041666666666668 + theta * 125.0 / 8.0)));
            double b5 = thetaH * (theta * (-0.3125 + theta * 5.0 / 12.0));
            interpolatedState = this.previousStateLinearCombination(b0, 0.0, b2, b3, b4, b5);
            interpolatedDerivatives = this.derivativeLinearCombination(bDot0, 0.0, bDot2, bDot3, bDot4, bDot5);
        } else {
            double theta2 = theta * theta;
            double h = thetaH / theta;
            double b0 = h * (-0.08333333333333333 + theta * (1.0 + theta * (-3.75 + theta * (5.333333333333333 + theta * -5.0 / 2.0))));
            double b1 = 0.0;
            double b2 = h * (-0.84375 + theta2 * (14.34375 + theta * (-30.375 + theta * 135.0 / 8.0)));
            double b3 = h * (1.3333333333333333 + theta2 * (-22.0 + theta * (50.666666666666664 + theta * -30.0)));
            double b4 = h * (-1.3020833333333333 + theta2 * (11.71875 + theta * (-26.041666666666668 + theta * 125.0 / 8.0)));
            double b5 = h * (-0.10416666666666667 + theta2 * (-0.3125 + theta * 5.0 / 12.0));
            interpolatedState = this.currentStateLinearCombination(b0, 0.0, b2, b3, b4, b5);
            interpolatedDerivatives = this.derivativeLinearCombination(bDot0, 0.0, bDot2, bDot3, bDot4, bDot5);
        }
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

