/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.AbstractIntegrator;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.ExplicitRungeKuttaIntegrator;
import org.hipparchus.ode.nonstiff.interpolators.RungeKuttaStateInterpolator;
import org.hipparchus.util.FastMath;

public abstract class FixedStepRungeKuttaIntegrator
extends AbstractIntegrator
implements ExplicitRungeKuttaIntegrator {
    private final double[] c = this.getC();
    private final double[][] a = this.getA();
    private final double[] b = this.getB();
    private final double step;

    protected FixedStepRungeKuttaIntegrator(String name, double step) {
        super(name);
        this.step = FastMath.abs((double)step);
    }

    public double getDefaultStep() {
        return this.step;
    }

    protected abstract RungeKuttaStateInterpolator createInterpolator(boolean var1, double[][] var2, ODEStateAndDerivative var3, ODEStateAndDerivative var4, EquationsMapper var5);

    @Override
    public ODEStateAndDerivative integrate(ExpandableODE equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = finalTime > initialState.getTime();
        int stages = this.c.length + 1;
        double[] y = this.getStepStart().getCompleteState();
        double[][] yDotK = new double[stages][];
        double[] yTmp = new double[y.length];
        if (forward) {
            if (this.getStepStart().getTime() + this.step >= finalTime) {
                this.setStepSize(finalTime - this.getStepStart().getTime());
            } else {
                this.setStepSize(this.step);
            }
        } else if (this.getStepStart().getTime() - this.step <= finalTime) {
            this.setStepSize(finalTime - this.getStepStart().getTime());
        } else {
            this.setStepSize(-this.step);
        }
        this.setIsLastStep(false);
        do {
            boolean nextIsLast;
            y = this.getStepStart().getCompleteState();
            yDotK[0] = this.getStepStart().getCompleteDerivative();
            ExplicitRungeKuttaIntegrator.applyInternalButcherWeights(this.getEquations(), this.getStepStart().getTime(), y, this.getStepSize(), this.a, this.c, yDotK);
            this.incrementEvaluations(stages - 1);
            for (int j = 0; j < y.length; ++j) {
                double sum = this.b[0] * yDotK[0][j];
                for (int l = 1; l < stages; ++l) {
                    sum += this.b[l] * yDotK[l][j];
                }
                yTmp[j] = y[j] + this.getStepSize() * sum;
                if (!Double.isNaN(yTmp[j])) continue;
                throw new MathIllegalStateException((Localizable)LocalizedODEFormats.NAN_APPEARING_DURING_INTEGRATION, new Object[]{this.getStepStart().getTime() + this.getStepSize()});
            }
            double stepEnd = this.getStepStart().getTime() + this.getStepSize();
            double[] yDotTmp = this.computeDerivatives(stepEnd, yTmp);
            ODEStateAndDerivative stateTmp = equations.getMapper().mapStateAndDerivative(stepEnd, yTmp, yDotTmp);
            System.arraycopy(yTmp, 0, y, 0, y.length);
            this.setStepStart(this.acceptStep(this.createInterpolator(forward, yDotK, this.getStepStart(), stateTmp, equations.getMapper()), finalTime));
            if (this.isLastStep()) continue;
            double nextT = this.getStepStart().getTime() + this.getStepSize();
            boolean bl = forward ? nextT >= finalTime : (nextIsLast = nextT <= finalTime);
            if (!nextIsLast) continue;
            this.setStepSize(finalTime - this.getStepStart().getTime());
        } while (!this.isLastStep());
        ODEStateAndDerivative finalState = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(Double.NaN);
        return finalState;
    }
}

