/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.EmbeddedRungeKuttaIntegrator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.ode.nonstiff.interpolators.DormandPrince54StateInterpolator;
import org.hipparchus.util.FastMath;

public class DormandPrince54Integrator
extends EmbeddedRungeKuttaIntegrator {
    public static final String METHOD_NAME = "Dormand-Prince 5 (4)";
    static final double E1 = 0.0012326388888888888;
    static final double E3 = -0.0042527702905061394;
    static final double E4 = 0.03697916666666667;
    static final double E5 = -0.05086379716981132;
    static final double E6 = 0.0419047619047619;
    static final double E7 = -0.025;

    public DormandPrince54Integrator(double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(METHOD_NAME, 6, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public DormandPrince54Integrator(double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(METHOD_NAME, 6, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    public double[] getC() {
        return new double[]{0.2, 0.3, 0.8, 0.8888888888888888, 1.0, 1.0};
    }

    @Override
    public double[][] getA() {
        return new double[][]{{0.2}, {0.075, 0.225}, {0.9777777777777777, -3.7333333333333334, 3.5555555555555554}, {2.9525986892242035, -11.595793324188385, 9.822892851699436, -0.2908093278463649}, {2.8462752525252526, -10.757575757575758, 8.906422717743473, 0.2784090909090909, -0.2735313036020583}, {0.09114583333333333, 0.0, 0.44923629829290207, 0.6510416666666666, -0.322376179245283, 0.13095238095238096}};
    }

    @Override
    public double[] getB() {
        return new double[]{0.09114583333333333, 0.0, 0.44923629829290207, 0.6510416666666666, -0.322376179245283, 0.13095238095238096, 0.0};
    }

    @Override
    protected DormandPrince54StateInterpolator createInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, EquationsMapper mapper) {
        return new DormandPrince54StateInterpolator(forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    protected double estimateError(double[][] yDotK, double[] y0, double[] y1, double h) {
        StepsizeHelper helper = this.getStepSizeHelper();
        double error = 0.0;
        for (int j = 0; j < helper.getMainSetDimension(); ++j) {
            double errSum = 0.0012326388888888888 * yDotK[0][j] + -0.0042527702905061394 * yDotK[2][j] + 0.03697916666666667 * yDotK[3][j] + -0.05086379716981132 * yDotK[4][j] + 0.0419047619047619 * yDotK[5][j] + -0.025 * yDotK[6][j];
            double tol = helper.getTolerance(j, FastMath.max((double)FastMath.abs((double)y0[j]), (double)FastMath.abs((double)y1[j])));
            double ratio = h * errSum / tol;
            error += ratio * ratio;
        }
        return FastMath.sqrt((double)(error / (double)helper.getMainSetDimension()));
    }
}

