/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.AbstractIntegrator;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.util.FastMath;

public abstract class AdaptiveStepsizeIntegrator
extends AbstractIntegrator {
    private StepsizeHelper stepsizeHelper;

    protected AdaptiveStepsizeIntegrator(String name, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(name);
        this.stepsizeHelper = new StepsizeHelper(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.resetInternalState();
    }

    protected AdaptiveStepsizeIntegrator(String name, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(name);
        this.stepsizeHelper = new StepsizeHelper(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.resetInternalState();
    }

    public void setStepSizeControl(double minimalStep, double maximalStep, double absoluteTolerance, double relativeTolerance) {
        this.stepsizeHelper = new StepsizeHelper(minimalStep, maximalStep, absoluteTolerance, relativeTolerance);
    }

    public void setStepSizeControl(double minimalStep, double maximalStep, double[] absoluteTolerance, double[] relativeTolerance) {
        this.stepsizeHelper = new StepsizeHelper(minimalStep, maximalStep, absoluteTolerance, relativeTolerance);
    }

    protected StepsizeHelper getStepSizeHelper() {
        return this.stepsizeHelper;
    }

    public void setInitialStepSize(double initialStepSize) {
        this.stepsizeHelper.setInitialStepSize(initialStepSize);
    }

    @Override
    protected void sanityChecks(ODEState initialState, double t) throws MathIllegalArgumentException {
        super.sanityChecks(initialState, t);
        this.stepsizeHelper.setMainSetDimension(initialState.getPrimaryStateDimension());
    }

    public double initializeStep(boolean forward, int order, double[] scale, ODEStateAndDerivative state0) throws MathIllegalArgumentException, MathIllegalStateException {
        double h;
        if (this.stepsizeHelper.getInitialStep() > 0.0) {
            return forward ? this.stepsizeHelper.getInitialStep() : -this.stepsizeHelper.getInitialStep();
        }
        double[] y0 = state0.getCompleteState();
        double[] yDot0 = state0.getCompleteDerivative();
        double yOnScale2 = 0.0;
        double yDotOnScale2 = 0.0;
        for (int j = 0; j < scale.length; ++j) {
            double ratio = y0[j] / scale[j];
            yOnScale2 += ratio * ratio;
            double ratioDot = yDot0[j] / scale[j];
            yDotOnScale2 += ratioDot * ratioDot;
        }
        double d = h = yOnScale2 < 1.0E-10 || yDotOnScale2 < 1.0E-10 ? 1.0E-6 : 0.01 * FastMath.sqrt((double)(yOnScale2 / yDotOnScale2));
        if (h > this.getMaxStep()) {
            h = this.getMaxStep();
        }
        if (!forward) {
            h = -h;
        }
        double[] y1 = new double[y0.length];
        for (int j = 0; j < y0.length; ++j) {
            y1[j] = y0[j] + h * yDot0[j];
        }
        double[] yDot1 = this.computeDerivatives(state0.getTime() + h, y1);
        double yDDotOnScale = 0.0;
        for (int j = 0; j < scale.length; ++j) {
            double ratioDotDot = (yDot1[j] - yDot0[j]) / scale[j];
            yDDotOnScale += ratioDotDot * ratioDotDot;
        }
        yDDotOnScale = FastMath.sqrt((double)yDDotOnScale) / h;
        double maxInv2 = FastMath.max((double)FastMath.sqrt((double)yDotOnScale2), (double)yDDotOnScale);
        double h1 = maxInv2 < 1.0E-15 ? FastMath.max((double)1.0E-6, (double)(0.001 * FastMath.abs((double)h))) : FastMath.pow((double)(0.01 / maxInv2), (double)(1.0 / (double)order));
        h = FastMath.min((double)(100.0 * FastMath.abs((double)h)), (double)h1);
        if ((h = FastMath.max((double)h, (double)(1.0E-12 * FastMath.abs((double)state0.getTime())))) < this.getMinStep()) {
            h = this.getMinStep();
        }
        if (h > this.getMaxStep()) {
            h = this.getMaxStep();
        }
        if (!forward) {
            h = -h;
        }
        return h;
    }

    protected void resetInternalState() {
        this.setStepStart(null);
        this.setStepSize(this.stepsizeHelper.getDummyStepsize());
    }

    public double getMinStep() {
        return this.stepsizeHelper.getMinStep();
    }

    public double getMaxStep() {
        return this.stepsizeHelper.getMaxStep();
    }
}

