/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.MultistepFieldIntegrator;
import org.hipparchus.ode.nonstiff.AdamsNordsieckFieldTransformer;
import org.hipparchus.ode.nonstiff.interpolators.AdamsFieldStateInterpolator;
import org.hipparchus.util.MathArrays;

public abstract class AdamsFieldIntegrator<T extends CalculusFieldElement<T>>
extends MultistepFieldIntegrator<T> {
    private final AdamsNordsieckFieldTransformer<T> transformer;

    protected AdamsFieldIntegrator(Field<T> field, String name, int nSteps, int order, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(field, name, nSteps, order, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.transformer = AdamsNordsieckFieldTransformer.getInstance(field, nSteps);
    }

    protected AdamsFieldIntegrator(Field<T> field, String name, int nSteps, int order, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super(field, name, nSteps, order, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.transformer = AdamsNordsieckFieldTransformer.getInstance(field, nSteps);
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> equations, FieldODEState<T> initialState, T finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = ((CalculusFieldElement)finalTime.subtract(initialState.getTime())).getReal() > 0.0;
        this.start(equations, this.getStepStart(), finalTime);
        FieldODEStateAndDerivative stepStart = this.getStepStart();
        FieldODEStateAndDerivative stepEnd = AdamsFieldStateInterpolator.taylor(equations.getMapper(), stepStart, (CalculusFieldElement)((CalculusFieldElement)stepStart.getTime().add(this.getStepSize())), this.getStepSize(), (CalculusFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
        this.setIsLastStep(false);
        CalculusFieldElement[] y = stepStart.getCompleteState();
        do {
            CalculusFieldElement[] predictedY = null;
            CalculusFieldElement[] predictedScaled = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)y.length);
            Array2DRowFieldMatrix<T> predictedNordsieck = null;
            double error = 10.0;
            while (error >= 1.0) {
                predictedY = stepEnd.getCompleteState();
                CalculusFieldElement[] yDot = this.computeDerivatives((CalculusFieldElement)stepEnd.getTime(), predictedY);
                for (int j = 0; j < predictedScaled.length; ++j) {
                    predictedScaled[j] = (CalculusFieldElement)this.getStepSize().multiply((FieldElement)yDot[j]);
                }
                predictedNordsieck = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                this.updateHighOrderDerivativesPhase2(this.scaled, predictedScaled, predictedNordsieck);
                error = this.errorEstimation(y, (CalculusFieldElement)stepEnd.getTime(), predictedY, predictedScaled, (FieldMatrix)predictedNordsieck);
                if (Double.isNaN(error)) {
                    throw new MathIllegalStateException((Localizable)LocalizedODEFormats.NAN_APPEARING_DURING_INTEGRATION, new Object[]{stepEnd.getTime().getReal()});
                }
                if (!(error >= 1.0)) continue;
                double factor = this.computeStepGrowShrinkFactor(error);
                this.rescale(this.getStepSizeHelper().filterStep((CalculusFieldElement)this.getStepSize().multiply(factor), forward, false));
                stepEnd = AdamsFieldStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), (CalculusFieldElement)((CalculusFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), (CalculusFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
            }
            AdamsFieldStateInterpolator interpolator = this.finalizeStep((CalculusFieldElement)this.getStepSize(), predictedY, predictedScaled, (Array2DRowFieldMatrix)predictedNordsieck, forward, this.getStepStart(), stepEnd, equations.getMapper());
            this.setStepStart(this.acceptStep(interpolator, finalTime));
            this.scaled = interpolator.getScaled();
            this.nordsieck = interpolator.getNordsieck();
            if (this.isLastStep()) continue;
            if (this.resetOccurred()) {
                this.start(equations, this.getStepStart(), finalTime);
                CalculusFieldElement nextT = (CalculusFieldElement)this.getStepStart().getTime().add(this.getStepSize());
                boolean nextIsLast = forward ? ((CalculusFieldElement)nextT.subtract(finalTime)).getReal() >= 0.0 : ((CalculusFieldElement)nextT.subtract(finalTime)).getReal() <= 0.0;
                Object hNew = nextIsLast ? (CalculusFieldElement)finalTime.subtract(this.getStepStart().getTime()) : this.getStepSize();
                this.rescale(hNew);
                System.arraycopy(this.getStepStart().getCompleteState(), 0, y, 0, y.length);
            } else {
                boolean filteredNextIsLast;
                double factor = this.computeStepGrowShrinkFactor(error);
                CalculusFieldElement scaledH = (CalculusFieldElement)this.getStepSize().multiply(factor);
                CalculusFieldElement nextT = (CalculusFieldElement)this.getStepStart().getTime().add((FieldElement)scaledH);
                boolean nextIsLast = forward ? ((CalculusFieldElement)nextT.subtract(finalTime)).getReal() >= 0.0 : ((CalculusFieldElement)nextT.subtract(finalTime)).getReal() <= 0.0;
                CalculusFieldElement hNew = this.getStepSizeHelper().filterStep(scaledH, forward, nextIsLast);
                CalculusFieldElement filteredNextT = (CalculusFieldElement)this.getStepStart().getTime().add((FieldElement)hNew);
                boolean bl = forward ? ((CalculusFieldElement)filteredNextT.subtract(finalTime)).getReal() >= 0.0 : (filteredNextIsLast = ((CalculusFieldElement)filteredNextT.subtract(finalTime)).getReal() <= 0.0);
                if (filteredNextIsLast) {
                    hNew = (CalculusFieldElement)finalTime.subtract(this.getStepStart().getTime());
                }
                this.rescale(hNew);
                System.arraycopy(predictedY, 0, y, 0, y.length);
            }
            stepEnd = AdamsFieldStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), (CalculusFieldElement)((CalculusFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), (CalculusFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
        } while (!this.isLastStep());
        FieldODEStateAndDerivative finalState = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(null);
        return finalState;
    }

    @Override
    protected Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T h, T[] t, T[][] y, T[][] yDot) {
        return this.transformer.initializeHighOrderDerivatives((CalculusFieldElement)h, (CalculusFieldElement[])t, (CalculusFieldElement[][])y, (CalculusFieldElement[][])yDot);
    }

    public Array2DRowFieldMatrix<T> updateHighOrderDerivativesPhase1(Array2DRowFieldMatrix<T> highOrder) {
        return this.transformer.updateHighOrderDerivativesPhase1(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(T[] start, T[] end, Array2DRowFieldMatrix<T> highOrder) {
        this.transformer.updateHighOrderDerivativesPhase2((CalculusFieldElement[])start, (CalculusFieldElement[])end, (Array2DRowFieldMatrix)highOrder);
    }

    protected abstract double errorEstimation(T[] var1, T var2, T[] var3, T[] var4, FieldMatrix<T> var5);

    protected abstract AdamsFieldStateInterpolator<T> finalizeStep(T var1, T[] var2, T[] var3, Array2DRowFieldMatrix<T> var4, boolean var5, FieldODEStateAndDerivative<T> var6, FieldODEStateAndDerivative<T> var7, FieldEquationsMapper<T> var8);
}

