/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FieldEventOccurrence;
import org.hipparchus.ode.events.FieldEventState;
import org.hipparchus.ode.events.FieldODEStepEndHandler;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;

public class FieldStepEndEventState<T extends CalculusFieldElement<T>>
implements FieldEventState<T> {
    private final FieldODEStepEndHandler<T> handler;
    private T stepEnd;
    private boolean forward;

    public FieldStepEndEventState(FieldODEStepEndHandler<T> handler) {
        this.handler = handler;
        this.stepEnd = null;
    }

    public FieldODEStepEndHandler<T> getHandler() {
        return this.handler;
    }

    @Override
    public void init(FieldODEStateAndDerivative<T> s0, T t) {
        this.forward = ((CalculusFieldElement)t.subtract(s0.getTime())).getReal() >= 0.0;
    }

    public void setStepEnd(T stepEnd) {
        this.stepEnd = stepEnd;
    }

    @Override
    public boolean evaluateStep(FieldODEStateInterpolator<T> interpolator) {
        return this.stepEnd != null && ((CalculusFieldElement)this.stepEnd.subtract(interpolator.getCurrentState().getTime())).isZero();
    }

    @Override
    public T getEventTime() {
        return this.stepEnd;
    }

    @Override
    public FieldEventOccurrence<T> doEvent(FieldODEStateAndDerivative<T> state) {
        Action action = this.handler.stepEndOccurred(state, this.forward);
        FieldODEState newState = action == Action.RESET_STATE ? this.handler.resetState(state) : state;
        FieldEventOccurrence<T> occurrence = new FieldEventOccurrence<T>(action, newState, this.stepEnd);
        this.setStepEnd(null);
        return occurrence;
    }
}

