/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.events.AdaptableInterval;
import org.hipparchus.ode.events.ODEEventDetector;
import org.hipparchus.ode.events.ODEEventHandler;

public abstract class AbstractODEDetector<T extends AbstractODEDetector<T>>
implements ODEEventDetector {
    public static final double DEFAULT_MAX_CHECK = 600.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-6;
    public static final int DEFAULT_MAX_ITER = 100;
    private final AdaptableInterval maxCheck;
    private final int maxIter;
    private final BracketedUnivariateSolver<UnivariateFunction> solver;
    private final ODEEventHandler handler;
    private boolean forward;

    protected AbstractODEDetector(AdaptableInterval maxCheck, int maxIter, BracketedUnivariateSolver<UnivariateFunction> solver, ODEEventHandler handler) {
        this.maxCheck = maxCheck;
        this.maxIter = maxIter;
        this.solver = solver;
        this.handler = handler;
        this.forward = true;
    }

    @Override
    public void init(ODEStateAndDerivative s0, double t) {
        ODEEventDetector.super.init(s0, t);
        this.forward = t >= s0.getTime();
    }

    @Override
    public AdaptableInterval getMaxCheckInterval() {
        return this.maxCheck;
    }

    @Override
    public int getMaxIterationCount() {
        return this.maxIter;
    }

    @Override
    public BracketedUnivariateSolver<UnivariateFunction> getSolver() {
        return this.solver;
    }

    public T withMaxCheck(double newMaxCheck) {
        return this.withMaxCheck(AdaptableInterval.of(newMaxCheck));
    }

    public T withMaxCheck(AdaptableInterval newMaxCheck) {
        return this.create(newMaxCheck, this.getMaxIterationCount(), this.getSolver(), this.getHandler());
    }

    public T withMaxIter(int newMaxIter) {
        return this.create(this.getMaxCheckInterval(), newMaxIter, this.getSolver(), this.getHandler());
    }

    public T withThreshold(double newThreshold) {
        return this.withSolver((BracketedUnivariateSolver<UnivariateFunction>)new BracketingNthOrderBrentSolver(0.0, newThreshold, 0.0, 5));
    }

    public T withSolver(BracketedUnivariateSolver<UnivariateFunction> newSolver) {
        return this.create(this.getMaxCheckInterval(), this.getMaxIterationCount(), newSolver, this.getHandler());
    }

    public T withHandler(ODEEventHandler newHandler) {
        return this.create(this.getMaxCheckInterval(), this.getMaxIterationCount(), this.getSolver(), newHandler);
    }

    @Override
    public ODEEventHandler getHandler() {
        return this.handler;
    }

    protected abstract T create(AdaptableInterval var1, int var2, BracketedUnivariateSolver<UnivariateFunction> var3, ODEEventHandler var4);

    public boolean isForward() {
        return this.forward;
    }
}

