/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.FieldOrdinaryDifferentialEquation;
import org.hipparchus.ode.events.FieldODEEventDetector;
import org.hipparchus.ode.events.FieldODEStepEndHandler;
import org.hipparchus.ode.sampling.FieldODEStepHandler;

public interface FieldODEIntegrator<T extends CalculusFieldElement<T>> {
    public String getName();

    public void addStepHandler(FieldODEStepHandler<T> var1);

    public List<FieldODEStepHandler<T>> getStepHandlers();

    public void clearStepHandlers();

    public void addEventDetector(FieldODEEventDetector<T> var1);

    public List<FieldODEEventDetector<T>> getEventDetectors();

    public void clearEventDetectors();

    public void addStepEndHandler(FieldODEStepEndHandler<T> var1);

    public List<FieldODEStepEndHandler<T>> getStepEndHandlers();

    public void clearStepEndHandlers();

    public FieldODEStateAndDerivative<T> getStepStart();

    public T getCurrentSignedStepsize();

    public void setMaxEvaluations(int var1);

    public int getMaxEvaluations();

    public int getEvaluations();

    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> var1, FieldODEState<T> var2, T var3) throws MathIllegalArgumentException, MathIllegalStateException;

    default public FieldODEStateAndDerivative<T> integrate(FieldOrdinaryDifferentialEquation<T> equations, FieldODEState<T> initialState, T finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        return this.integrate(new FieldExpandableODE<T>(equations), initialState, finalTime);
    }
}

