/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldOrdinaryDifferentialEquation;
import org.hipparchus.ode.FieldSecondaryODE;
import org.hipparchus.util.MathArrays;

public class FieldExpandableODE<T extends CalculusFieldElement<T>> {
    private final FieldOrdinaryDifferentialEquation<T> primary;
    private List<FieldSecondaryODE<T>> components;
    private FieldEquationsMapper<T> mapper;

    public FieldExpandableODE(FieldOrdinaryDifferentialEquation<T> primary) {
        this.primary = primary;
        this.components = new ArrayList<FieldSecondaryODE<T>>();
        this.mapper = new FieldEquationsMapper(null, primary.getDimension());
    }

    public FieldOrdinaryDifferentialEquation<T> getPrimary() {
        return this.primary;
    }

    public FieldEquationsMapper<T> getMapper() {
        return this.mapper;
    }

    public int addSecondaryEquations(FieldSecondaryODE<T> secondary) {
        this.components.add(secondary);
        this.mapper = new FieldEquationsMapper<T>(this.mapper, secondary.getDimension());
        return this.components.size();
    }

    public void init(FieldODEState<T> s0, T finalTime) {
        T t0 = s0.getTime();
        CalculusFieldElement[] primary0 = s0.getPrimaryState();
        this.primary.init((CalculusFieldElement)t0, primary0, (CalculusFieldElement)finalTime);
        for (int index = 1; index < this.mapper.getNumberOfEquations(); ++index) {
            CalculusFieldElement[] secondary0 = s0.getSecondaryState(index);
            this.components.get(index - 1).init((CalculusFieldElement)t0, primary0, secondary0, (CalculusFieldElement)finalTime);
        }
    }

    public T[] computeDerivatives(T t, T[] y) throws MathIllegalArgumentException, MathIllegalStateException {
        CalculusFieldElement[] yDot = (CalculusFieldElement[])MathArrays.buildArray((Field)t.getField(), (int)this.mapper.getTotalDimension());
        CalculusFieldElement[] primaryState = this.mapper.extractEquationData(0, (CalculusFieldElement[])y);
        CalculusFieldElement[] primaryStateDot = this.primary.computeDerivatives((CalculusFieldElement)t, primaryState);
        for (int index = 1; index < this.mapper.getNumberOfEquations(); ++index) {
            CalculusFieldElement[] componentState = this.mapper.extractEquationData(index, (CalculusFieldElement[])y);
            CalculusFieldElement[] componentStateDot = this.components.get(index - 1).computeDerivatives((CalculusFieldElement)t, primaryState, primaryStateDot, componentState);
            this.mapper.insertEquationData(index, componentStateDot, yDot);
        }
        this.mapper.insertEquationData(0, primaryStateDot, yDot);
        return yDot;
    }
}

