/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FieldDetectorBasedEventState;
import org.hipparchus.ode.events.FieldEventOccurrence;
import org.hipparchus.ode.events.FieldEventState;
import org.hipparchus.ode.events.FieldODEEventDetector;
import org.hipparchus.ode.events.FieldODEStepEndHandler;
import org.hipparchus.ode.events.FieldStepEndEventState;
import org.hipparchus.ode.sampling.AbstractFieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Incrementor;

public abstract class AbstractFieldIntegrator<T extends CalculusFieldElement<T>>
implements FieldODEIntegrator<T> {
    private final List<FieldODEStepHandler<T>> stepHandlers;
    private FieldODEStateAndDerivative<T> stepStart;
    private T stepSize;
    private boolean isLastStep;
    private boolean resetOccurred;
    private final Field<T> field;
    private final List<FieldDetectorBasedEventState<T>> detectorBasedEventsStates;
    private final List<FieldStepEndEventState<T>> stepEndEventsStates;
    private boolean statesInitialized;
    private final String name;
    private Incrementor evaluations;
    private transient FieldExpandableODE<T> equations;

    protected AbstractFieldIntegrator(Field<T> field, String name) {
        this.field = field;
        this.name = name;
        this.stepHandlers = new ArrayList<FieldODEStepHandler<T>>();
        this.stepStart = null;
        this.stepSize = null;
        this.detectorBasedEventsStates = new ArrayList<FieldDetectorBasedEventState<T>>();
        this.stepEndEventsStates = new ArrayList<FieldStepEndEventState<T>>();
        this.statesInitialized = false;
        this.evaluations = new Incrementor();
    }

    public Field<T> getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(FieldODEStepHandler<T> handler) {
        this.stepHandlers.add(handler);
    }

    @Override
    public List<FieldODEStepHandler<T>> getStepHandlers() {
        return Collections.unmodifiableList(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventDetector(FieldODEEventDetector<T> detector) {
        this.detectorBasedEventsStates.add(new FieldDetectorBasedEventState<T>(detector));
    }

    @Override
    public List<FieldODEEventDetector<T>> getEventDetectors() {
        return this.detectorBasedEventsStates.stream().map(FieldDetectorBasedEventState::getEventDetector).collect(Collectors.toList());
    }

    @Override
    public void clearEventDetectors() {
        this.detectorBasedEventsStates.clear();
    }

    @Override
    public void addStepEndHandler(FieldODEStepEndHandler<T> handler) {
        this.stepEndEventsStates.add(new FieldStepEndEventState<T>(handler));
    }

    @Override
    public List<FieldODEStepEndHandler<T>> getStepEndHandlers() {
        return this.stepEndEventsStates.stream().map(FieldStepEndEventState::getHandler).collect(Collectors.toList());
    }

    @Override
    public void clearStepEndHandlers() {
        this.stepEndEventsStates.clear();
    }

    @Override
    public T getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.evaluations = this.evaluations.withMaximalCount(maxEvaluations < 0 ? Integer.MAX_VALUE : maxEvaluations);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    protected FieldODEStateAndDerivative<T> initIntegration(FieldExpandableODE<T> eqn, FieldODEState<T> s0, T t) {
        this.equations = eqn;
        this.evaluations = this.evaluations.withCount(0);
        eqn.init(s0, t);
        T t0 = s0.getTime();
        CalculusFieldElement[] y0 = s0.getCompleteState();
        CalculusFieldElement[] y0Dot = this.computeDerivatives((CalculusFieldElement)t0, y0);
        FieldODEStateAndDerivative s0WithDerivatives = eqn.getMapper().mapStateAndDerivative((CalculusFieldElement)t0, y0, y0Dot);
        this.detectorBasedEventsStates.forEach(s -> {
            s.init(s0WithDerivatives, t);
            s.getEventDetector().getHandler().init(s0WithDerivatives, (CalculusFieldElement)t, s.getEventDetector());
        });
        this.stepEndEventsStates.forEach(s -> {
            s.init(s0WithDerivatives, t);
            s.getHandler().init(s0WithDerivatives, (CalculusFieldElement)t);
        });
        for (FieldODEStepHandler<T> handler : this.stepHandlers) {
            handler.init(s0WithDerivatives, t);
        }
        this.setStateInitialized(false);
        return s0WithDerivatives;
    }

    protected FieldExpandableODE<T> getEquations() {
        return this.equations;
    }

    protected Incrementor getEvaluationsCounter() {
        return this.evaluations;
    }

    public T[] computeDerivatives(T t, T[] y) throws MathIllegalArgumentException, MathIllegalStateException, NullPointerException {
        this.evaluations.increment();
        return this.equations.computeDerivatives((CalculusFieldElement)t, (CalculusFieldElement[])y);
    }

    protected void incrementEvaluations(int nTimes) {
        this.evaluations.increment(nTimes);
    }

    protected void setStateInitialized(boolean stateInitialized) {
        this.statesInitialized = stateInitialized;
    }

    /*
     * WARNING - void declaration
     */
    protected FieldODEStateAndDerivative<T> acceptStep(AbstractFieldODEStateInterpolator<T> interpolator, T tEnd) throws MathIllegalArgumentException, MathIllegalStateException {
        FieldODEStateAndDerivative previousState = interpolator.getGlobalPreviousState();
        FieldODEStateAndDerivative currentState = interpolator.getGlobalCurrentState();
        FieldODEStateInterpolator restricted = interpolator;
        if (!this.statesInitialized) {
            this.detectorBasedEventsStates.forEach(s -> s.reinitializeBegin(interpolator));
            this.statesInitialized = true;
        }
        this.stepEndEventsStates.forEach(s -> s.setStepEnd(currentState.getTime()));
        for (FieldODEStepHandler handler : this.stepHandlers) {
            handler.updateOnStep(interpolator);
        }
        final int orderingSign = interpolator.isForward() ? 1 : -1;
        PriorityQueue<Object> occurringEvents = new PriorityQueue<Object>(new Comparator<FieldEventState<T>>(){

            @Override
            public int compare(FieldEventState<T> es0, FieldEventState<T> es1) {
                return orderingSign * Double.compare(es0.getEventTime().getReal(), es1.getEventTime().getReal());
            }
        });
        this.resetOccurred = false;
        boolean doneWithStep = false;
        block1: do {
            occurringEvents.clear();
            AbstractFieldODEStateInterpolator finalRestricted = restricted;
            Stream.concat(this.detectorBasedEventsStates.stream(), this.stepEndEventsStates.stream()).forEach(s -> {
                if (s.evaluateStep(finalRestricted)) {
                    occurringEvents.add(s);
                }
            });
            block2: while (true) {
                if (!occurringEvents.isEmpty()) {
                    void var11_15;
                    FieldEventState currentEvent = (FieldEventState)occurringEvents.poll();
                    FieldODEStateAndDerivative fieldODEStateAndDerivative = restricted.getInterpolatedState(currentEvent.getEventTime());
                    restricted = restricted.restrictStep(previousState, fieldODEStateAndDerivative);
                    for (FieldDetectorBasedEventState fieldDetectorBasedEventState : this.detectorBasedEventsStates) {
                        if (fieldDetectorBasedEventState == currentEvent || !fieldDetectorBasedEventState.tryAdvance(fieldODEStateAndDerivative, interpolator)) continue;
                        occurringEvents.remove(fieldDetectorBasedEventState);
                        occurringEvents.add(fieldDetectorBasedEventState);
                        occurringEvents.add(currentEvent);
                        continue block2;
                    }
                    for (FieldODEStepHandler fieldODEStepHandler : this.stepHandlers) {
                        fieldODEStepHandler.handleStep(restricted);
                    }
                    FieldEventOccurrence occurrence = currentEvent.doEvent(fieldODEStateAndDerivative);
                    Action action = occurrence.getAction();
                    boolean bl = this.isLastStep = action == Action.STOP;
                    if (this.isLastStep) {
                        FieldODEStateAndDerivative savedState = fieldODEStateAndDerivative;
                        FieldODEStateAndDerivative fieldODEStateAndDerivative2 = interpolator.getInterpolatedState(occurrence.getStopTime());
                        restricted = interpolator.restrictStep(savedState, fieldODEStateAndDerivative2);
                        for (FieldODEStepHandler handler : this.stepHandlers) {
                            handler.handleStep(restricted);
                            handler.finish(restricted.getCurrentState());
                        }
                    }
                    if (this.isLastStep) {
                        return var11_15;
                    }
                    if (action == Action.RESET_DERIVATIVES || action == Action.RESET_STATE) {
                        FieldODEState newState = occurrence.getNewState();
                        CalculusFieldElement[] y = newState.getCompleteState();
                        CalculusFieldElement[] yDot = this.computeDerivatives((CalculusFieldElement)newState.getTime(), y);
                        this.resetOccurred = true;
                        FieldODEStateAndDerivative newStateAndDerivative = this.equations.getMapper().mapStateAndDerivative((CalculusFieldElement)newState.getTime(), y, yDot);
                        this.detectorBasedEventsStates.forEach(e -> e.getEventDetector().reset(newStateAndDerivative, (CalculusFieldElement)tEnd));
                        return newStateAndDerivative;
                    }
                    previousState = var11_15;
                    restricted = restricted.restrictStep(var11_15, currentState);
                    if (action == Action.RESET_EVENTS) continue block1;
                    if (!currentEvent.evaluateStep(restricted)) continue;
                    occurringEvents.add(currentEvent);
                    continue;
                }
                for (FieldDetectorBasedEventState fieldDetectorBasedEventState : this.detectorBasedEventsStates) {
                    if (!fieldDetectorBasedEventState.tryAdvance(currentState, interpolator)) continue;
                    occurringEvents.add(fieldDetectorBasedEventState);
                }
                if (occurringEvents.isEmpty()) break;
            }
            doneWithStep = true;
        } while (!doneWithStep);
        this.isLastStep = this.isLastStep || ((CalculusFieldElement)currentState.getTime().subtract(tEnd)).norm() < FastMath.ulp((double)tEnd.getReal());
        for (FieldODEStepHandler handler : this.stepHandlers) {
            handler.handleStep(restricted);
            if (!this.isLastStep) continue;
            handler.finish(restricted.getCurrentState());
        }
        return currentState;
    }

    protected void sanityChecks(FieldODEState<T> initialState, T t) throws MathIllegalArgumentException {
        double threshold = 1000.0 * FastMath.ulp((double)FastMath.max((double)FastMath.abs((double)initialState.getTime().getReal()), (double)FastMath.abs((double)t.getReal())));
        double dt = ((CalculusFieldElement)initialState.getTime().subtract(t)).norm();
        if (dt < threshold) {
            throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.TOO_SMALL_INTEGRATION_INTERVAL, new Object[]{dt, threshold, false});
        }
    }

    protected boolean resetOccurred() {
        return this.resetOccurred;
    }

    protected void setStepSize(T stepSize) {
        this.stepSize = stepSize;
    }

    protected T getStepSize() {
        return this.stepSize;
    }

    protected void setStepStart(FieldODEStateAndDerivative<T> stepStart) {
        this.stepStart = stepStart;
    }

    @Override
    public FieldODEStateAndDerivative<T> getStepStart() {
        return this.stepStart;
    }

    protected void setIsLastStep(boolean isLastStep) {
        this.isLastStep = isLastStep;
    }

    protected boolean isLastStep() {
        return this.isLastStep;
    }
}

